/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.request;

import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.org.asynchttpclient.handler.ProgressAsyncHandler;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.channel.Channels;
import play.shaded.ahc.org.asynchttpclient.netty.future.StackTraceInspector;

public abstract class WriteListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteListener.class);
    protected final NettyResponseFuture<?> future;
    final ProgressAsyncHandler<?> progressAsyncHandler;
    final boolean notifyHeaders;

    WriteListener(NettyResponseFuture<?> future2, boolean notifyHeaders) {
        this.future = future2;
        this.progressAsyncHandler = future2.getAsyncHandler() instanceof ProgressAsyncHandler ? (ProgressAsyncHandler)future2.getAsyncHandler() : null;
        this.notifyHeaders = notifyHeaders;
    }

    private boolean abortOnThrowable(Channel channel, Throwable cause) {
        if (cause != null) {
            if (cause instanceof IllegalStateException || cause instanceof ClosedChannelException || StackTraceInspector.recoverOnReadOrWriteException(cause)) {
                LOGGER.debug(cause.getMessage(), cause);
                Channels.silentlyCloseChannel(channel);
            } else {
                this.future.abort(cause);
            }
            return true;
        }
        return false;
    }

    void operationComplete(Channel channel, Throwable cause) {
        this.future.touch();
        if (this.abortOnThrowable(channel, cause)) {
            return;
        }
        if (this.progressAsyncHandler != null) {
            boolean startPublishing;
            boolean bl = startPublishing = !this.future.isInAuth() && !this.future.isInProxyAuth();
            if (startPublishing) {
                if (this.notifyHeaders) {
                    this.progressAsyncHandler.onHeadersWritten();
                } else {
                    this.progressAsyncHandler.onContentWritten();
                }
            }
        }
    }
}

