/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.request;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.shaded.ahc.io.netty.bootstrap.Bootstrap;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelFuture;
import play.shaded.ahc.io.netty.channel.ChannelProgressivePromise;
import play.shaded.ahc.io.netty.channel.ChannelPromise;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderValues;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpMethod;
import play.shaded.ahc.io.netty.handler.codec.http.HttpRequest;
import play.shaded.ahc.io.netty.util.Timer;
import play.shaded.ahc.io.netty.util.concurrent.Future;
import play.shaded.ahc.io.netty.util.concurrent.GenericFutureListener;
import play.shaded.ahc.io.netty.util.concurrent.ImmediateEventExecutor;
import play.shaded.ahc.io.netty.util.concurrent.Promise;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientState;
import play.shaded.ahc.org.asynchttpclient.ListenableFuture;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.exception.PoolAlreadyClosedException;
import play.shaded.ahc.org.asynchttpclient.exception.RemotelyClosedException;
import play.shaded.ahc.org.asynchttpclient.filter.FilterContext;
import play.shaded.ahc.org.asynchttpclient.filter.FilterException;
import play.shaded.ahc.org.asynchttpclient.filter.IOExceptionFilter;
import play.shaded.ahc.org.asynchttpclient.handler.TransferCompletionHandler;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.OnLastHttpContentCallback;
import play.shaded.ahc.org.asynchttpclient.netty.SimpleFutureListener;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelManager;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelState;
import play.shaded.ahc.org.asynchttpclient.netty.channel.Channels;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ConnectionSemaphore;
import play.shaded.ahc.org.asynchttpclient.netty.channel.DefaultConnectionSemaphoreFactory;
import play.shaded.ahc.org.asynchttpclient.netty.channel.NettyChannelConnector;
import play.shaded.ahc.org.asynchttpclient.netty.channel.NettyConnectListener;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequest;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestFactory;
import play.shaded.ahc.org.asynchttpclient.netty.request.WriteCompleteListener;
import play.shaded.ahc.org.asynchttpclient.netty.request.WriteProgressListener;
import play.shaded.ahc.org.asynchttpclient.netty.timeout.TimeoutsHolder;
import play.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import play.shaded.ahc.org.asynchttpclient.resolver.RequestHostnameResolver;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import play.shaded.ahc.org.asynchttpclient.util.Assertions;
import play.shaded.ahc.org.asynchttpclient.util.AuthenticatorUtils;
import play.shaded.ahc.org.asynchttpclient.util.HttpConstants;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import play.shaded.ahc.org.asynchttpclient.util.ProxyUtils;
import play.shaded.ahc.org.asynchttpclient.ws.WebSocketUpgradeHandler;

public final class NettyRequestSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyRequestSender.class);
    private final AsyncHttpClientConfig config;
    private final ChannelManager channelManager;
    private final ConnectionSemaphore connectionSemaphore;
    private final Timer nettyTimer;
    private final AsyncHttpClientState clientState;
    private final NettyRequestFactory requestFactory;

    public NettyRequestSender(AsyncHttpClientConfig config, ChannelManager channelManager, Timer nettyTimer, AsyncHttpClientState clientState) {
        this.config = config;
        this.channelManager = channelManager;
        this.connectionSemaphore = config.getConnectionSemaphoreFactory() == null ? new DefaultConnectionSemaphoreFactory().newConnectionSemaphore(config) : config.getConnectionSemaphoreFactory().newConnectionSemaphore(config);
        this.nettyTimer = nettyTimer;
        this.clientState = clientState;
        this.requestFactory = new NettyRequestFactory(config);
    }

    public <T> ListenableFuture<T> sendRequest(Request request2, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future2) {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
        this.validateWebSocketRequest(request2, asyncHandler);
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request2);
        if (proxyServer != null && proxyServer.getProxyType().isHttp() && (request2.getUri().isSecured() || request2.getUri().isWebSocket()) && !this.isConnectAlreadyDone(request2, future2)) {
            if (future2 != null && future2.isConnectAllowed()) {
                return this.sendRequestWithCertainForceConnect(request2, asyncHandler, future2, proxyServer, true);
            }
            return this.sendRequestThroughProxy(request2, asyncHandler, future2, proxyServer);
        }
        return this.sendRequestWithCertainForceConnect(request2, asyncHandler, future2, proxyServer, false);
    }

    private boolean isConnectAlreadyDone(Request request2, NettyResponseFuture<?> future2) {
        return future2 != null && future2.getNettyRequest() != null && future2.getNettyRequest().getHttpRequest().method() == HttpMethod.CONNECT && !request2.getMethod().equals(HttpConstants.Methods.CONNECT);
    }

    private <T> ListenableFuture<T> sendRequestWithCertainForceConnect(Request request2, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future2, ProxyServer proxyServer, boolean performConnectRequest) {
        NettyResponseFuture<T> newFuture = this.newNettyRequestAndResponseFuture(request2, asyncHandler, future2, proxyServer, performConnectRequest);
        Channel channel = this.getOpenChannel(future2, request2, proxyServer, asyncHandler);
        return Channels.isChannelActive(channel) ? this.sendRequestWithOpenChannel(newFuture, asyncHandler, channel) : this.sendRequestWithNewChannel(request2, proxyServer, newFuture, asyncHandler);
    }

    private <T> ListenableFuture<T> sendRequestThroughProxy(Request request2, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future2, ProxyServer proxyServer) {
        Channel channel;
        NettyResponseFuture<T> newFuture = null;
        for (int i = 0; i < 3 && (channel = this.getOpenChannel(future2, request2, proxyServer, asyncHandler)) != null; ++i) {
            if (newFuture == null) {
                newFuture = this.newNettyRequestAndResponseFuture(request2, asyncHandler, future2, proxyServer, false);
            }
            if (!Channels.isChannelActive(channel)) continue;
            return this.sendRequestWithOpenChannel(newFuture, asyncHandler, channel);
        }
        newFuture = this.newNettyRequestAndResponseFuture(request2, asyncHandler, future2, proxyServer, true);
        return this.sendRequestWithNewChannel(request2, proxyServer, newFuture, asyncHandler);
    }

    private <T> NettyResponseFuture<T> newNettyRequestAndResponseFuture(Request request2, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> originalFuture, ProxyServer proxy, boolean performConnectRequest) {
        Realm realm;
        if (originalFuture != null) {
            realm = originalFuture.getRealm();
        } else {
            realm = request2.getRealm();
            if (realm == null) {
                realm = this.config.getRealm();
            }
        }
        Realm proxyRealm = null;
        if (originalFuture != null) {
            proxyRealm = originalFuture.getProxyRealm();
        } else if (proxy != null) {
            proxyRealm = proxy.getRealm();
        }
        NettyRequest nettyRequest = this.requestFactory.newNettyRequest(request2, performConnectRequest, proxy, realm, proxyRealm);
        if (originalFuture == null) {
            NettyResponseFuture<T> future2 = this.newNettyResponseFuture(request2, asyncHandler, nettyRequest, proxy);
            future2.setRealm(realm);
            future2.setProxyRealm(proxyRealm);
            return future2;
        }
        originalFuture.setNettyRequest(nettyRequest);
        originalFuture.setCurrentRequest(request2);
        return originalFuture;
    }

    private Channel getOpenChannel(NettyResponseFuture<?> future2, Request request2, ProxyServer proxyServer, AsyncHandler<?> asyncHandler) {
        if (future2 != null && future2.isReuseChannel() && Channels.isChannelActive(future2.channel())) {
            return future2.channel();
        }
        return this.pollPooledChannel(request2, proxyServer, asyncHandler);
    }

    private <T> ListenableFuture<T> sendRequestWithOpenChannel(NettyResponseFuture<T> future2, AsyncHandler<T> asyncHandler, Channel channel) {
        try {
            asyncHandler.onConnectionPooled(channel);
        }
        catch (Exception e) {
            LOGGER.error("onConnectionPooled crashed", e);
            this.abort(channel, future2, e);
            return future2;
        }
        SocketAddress channelRemoteAddress = channel.remoteAddress();
        if (channelRemoteAddress != null) {
            this.scheduleRequestTimeout(future2, (InetSocketAddress)channelRemoteAddress);
        }
        future2.setChannelState(ChannelState.POOLED);
        future2.attachChannel(channel, false);
        if (LOGGER.isDebugEnabled()) {
            HttpRequest httpRequest = future2.getNettyRequest().getHttpRequest();
            LOGGER.debug("Using open Channel {} for {} '{}'", channel, httpRequest.method(), httpRequest.uri());
        }
        Channels.setAttribute(channel, future2);
        if (Channels.isChannelActive(channel)) {
            this.writeRequest(future2, channel);
        } else {
            this.handleUnexpectedClosedChannel(channel, future2);
        }
        return future2;
    }

    private <T> ListenableFuture<T> sendRequestWithNewChannel(final Request request2, final ProxyServer proxy, final NettyResponseFuture<T> future2, final AsyncHandler<T> asyncHandler) {
        HttpHeaders headers = future2.getNettyRequest().getHttpRequest().headers();
        Realm realm = future2.getRealm();
        Realm proxyRealm = future2.getProxyRealm();
        this.requestFactory.addAuthorizationHeader(headers, AuthenticatorUtils.perConnectionAuthorizationHeader(request2, proxy, realm));
        this.requestFactory.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perConnectionProxyAuthorizationHeader(request2, proxyRealm));
        future2.setInAuth(realm != null && realm.isUsePreemptiveAuth() && realm.getScheme() != Realm.AuthScheme.NTLM);
        future2.setInProxyAuth(proxyRealm != null && proxyRealm.isUsePreemptiveAuth() && proxyRealm.getScheme() != Realm.AuthScheme.NTLM);
        try {
            if (!this.channelManager.isOpen()) {
                throw PoolAlreadyClosedException.INSTANCE;
            }
            future2.acquirePartitionLockLazily();
        }
        catch (Throwable t) {
            this.abort(null, future2, MiscUtils.getCause(t));
            return future2;
        }
        this.resolveAddresses(request2, proxy, future2, asyncHandler).addListener((GenericFutureListener<Future<List<InetSocketAddress>>>)new SimpleFutureListener<List<InetSocketAddress>>(){

            @Override
            protected void onSuccess(List<InetSocketAddress> addresses) {
                NettyConnectListener connectListener = new NettyConnectListener(future2, NettyRequestSender.this, NettyRequestSender.this.channelManager, NettyRequestSender.this.connectionSemaphore);
                NettyChannelConnector connector = new NettyChannelConnector(request2.getLocalAddress(), addresses, asyncHandler, NettyRequestSender.this.clientState);
                if (!future2.isDone()) {
                    NettyRequestSender.this.channelManager.getBootstrap(request2.getUri(), request2.getNameResolver(), proxy).addListener(whenBootstrap -> {
                        if (whenBootstrap.isSuccess()) {
                            connector.connect((Bootstrap)whenBootstrap.get(), connectListener);
                        } else {
                            NettyRequestSender.this.abort(null, future2, whenBootstrap.cause());
                        }
                    });
                }
            }

            @Override
            protected void onFailure(Throwable cause) {
                NettyRequestSender.this.abort(null, future2, MiscUtils.getCause(cause));
            }
        });
        return future2;
    }

    private <T> Future<List<InetSocketAddress>> resolveAddresses(Request request2, ProxyServer proxy, NettyResponseFuture<T> future2, AsyncHandler<T> asyncHandler) {
        Uri uri = request2.getUri();
        Promise<List<InetSocketAddress>> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        if (proxy != null && !proxy.isIgnoredForHost(uri.getHost()) && proxy.getProxyType().isHttp()) {
            int port = uri.isSecured() ? proxy.getSecuredPort() : proxy.getPort();
            InetSocketAddress unresolvedRemoteAddress = InetSocketAddress.createUnresolved(proxy.getHost(), port);
            this.scheduleRequestTimeout(future2, unresolvedRemoteAddress);
            return RequestHostnameResolver.INSTANCE.resolve(request2.getNameResolver(), unresolvedRemoteAddress, asyncHandler);
        }
        int port = uri.getExplicitPort();
        InetSocketAddress unresolvedRemoteAddress = InetSocketAddress.createUnresolved(uri.getHost(), port);
        this.scheduleRequestTimeout(future2, unresolvedRemoteAddress);
        if (request2.getAddress() != null) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(request2.getAddress(), port);
            return promise.setSuccess(Collections.singletonList(inetSocketAddress));
        }
        return RequestHostnameResolver.INSTANCE.resolve(request2.getNameResolver(), unresolvedRemoteAddress, asyncHandler);
    }

    private <T> NettyResponseFuture<T> newNettyResponseFuture(Request request2, AsyncHandler<T> asyncHandler, NettyRequest nettyRequest, ProxyServer proxyServer) {
        NettyResponseFuture<T> future2 = new NettyResponseFuture<T>(request2, asyncHandler, nettyRequest, this.config.getMaxRequestRetry(), request2.getChannelPoolPartitioning(), this.connectionSemaphore, proxyServer);
        String expectHeader = request2.getHeaders().get(HttpHeaderNames.EXPECT);
        if (HttpHeaderValues.CONTINUE.contentEqualsIgnoreCase(expectHeader)) {
            future2.setDontWriteBodyBecauseExpectContinue(true);
        }
        return future2;
    }

    public <T> void writeRequest(NettyResponseFuture<T> future2, Channel channel) {
        NettyRequest nettyRequest = future2.getNettyRequest();
        HttpRequest httpRequest = nettyRequest.getHttpRequest();
        AsyncHandler<T> asyncHandler = future2.getAsyncHandler();
        if (!Channels.isChannelActive(channel)) {
            return;
        }
        try {
            boolean writeBody2;
            if (asyncHandler instanceof TransferCompletionHandler) {
                this.configureTransferAdapter(asyncHandler, httpRequest);
            }
            boolean bl = writeBody2 = !future2.isDontWriteBodyBecauseExpectContinue() && httpRequest.method() != HttpMethod.CONNECT && nettyRequest.getBody() != null;
            if (!future2.isHeadersAlreadyWrittenOnContinue()) {
                try {
                    asyncHandler.onRequestSend(nettyRequest);
                }
                catch (Exception e) {
                    LOGGER.error("onRequestSend crashed", e);
                    this.abort(channel, future2, e);
                    return;
                }
                if (writeBody2) {
                    ChannelProgressivePromise promise = channel.newProgressivePromise();
                    ChannelFuture f2 = channel.write(httpRequest, promise);
                    f2.addListener(new WriteProgressListener(future2, true, 0L));
                } else {
                    ChannelPromise promise = channel.newPromise();
                    ChannelFuture f3 = channel.writeAndFlush(httpRequest, promise);
                    f3.addListener(new WriteCompleteListener(future2));
                }
            }
            if (writeBody2) {
                nettyRequest.getBody().write(channel, future2);
            }
            if (Channels.isChannelActive(channel)) {
                this.scheduleReadTimeout(future2);
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't write request", e);
            this.abort(channel, future2, e);
        }
    }

    private void configureTransferAdapter(AsyncHandler<?> handler, HttpRequest httpRequest) {
        HttpHeaders h = new DefaultHttpHeaders(false).set(httpRequest.headers());
        ((TransferCompletionHandler)TransferCompletionHandler.class.cast(handler)).headers(h);
    }

    private void scheduleRequestTimeout(NettyResponseFuture<?> nettyResponseFuture, InetSocketAddress originalRemoteAddress) {
        nettyResponseFuture.touch();
        TimeoutsHolder timeoutsHolder = new TimeoutsHolder(this.nettyTimer, nettyResponseFuture, this, this.config, originalRemoteAddress);
        nettyResponseFuture.setTimeoutsHolder(timeoutsHolder);
    }

    private void scheduleReadTimeout(NettyResponseFuture<?> nettyResponseFuture) {
        TimeoutsHolder timeoutsHolder = nettyResponseFuture.getTimeoutsHolder();
        if (timeoutsHolder != null) {
            nettyResponseFuture.touch();
            timeoutsHolder.startReadTimeout();
        }
    }

    public void abort(Channel channel, NettyResponseFuture<?> future2, Throwable t) {
        if (channel != null && channel.isActive()) {
            this.channelManager.closeChannel(channel);
        }
        if (!future2.isDone()) {
            future2.setChannelState(ChannelState.CLOSED);
            LOGGER.debug("Aborting Future {}\n", (Object)future2);
            LOGGER.debug(t.getMessage(), t);
            future2.abort(t);
        }
    }

    public void handleUnexpectedClosedChannel(Channel channel, NettyResponseFuture<?> future2) {
        if (Channels.isActiveTokenSet(channel)) {
            if (future2.isDone()) {
                this.channelManager.closeChannel(channel);
            } else if (future2.incrementRetryAndCheck() && this.retry(future2)) {
                future2.pendingException = null;
            } else {
                this.abort(channel, future2, future2.pendingException != null ? future2.pendingException : RemotelyClosedException.INSTANCE);
            }
        }
    }

    public boolean retry(NettyResponseFuture<?> future2) {
        if (this.isClosed()) {
            return false;
        }
        if (future2.isReplayPossible()) {
            future2.setChannelState(ChannelState.RECONNECTED);
            LOGGER.debug("Trying to recover request {}\n", (Object)future2.getNettyRequest().getHttpRequest());
            try {
                future2.getAsyncHandler().onRetry();
            }
            catch (Exception e) {
                LOGGER.error("onRetry crashed", e);
                this.abort(future2.channel(), future2, e);
                return false;
            }
            try {
                this.sendNextRequest(future2.getCurrentRequest(), future2);
                return true;
            }
            catch (Exception e) {
                this.abort(future2.channel(), future2, e);
                return false;
            }
        }
        LOGGER.debug("Unable to recover future {}\n", (Object)future2);
        return false;
    }

    public boolean applyIoExceptionFiltersAndReplayRequest(NettyResponseFuture<?> future2, IOException e, Channel channel) {
        boolean replayed = false;
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future2.getAsyncHandler()).request(future2.getCurrentRequest()).ioException(e).build();
        for (IOExceptionFilter asyncFilter : this.config.getIoExceptionFilters()) {
            try {
                fc = asyncFilter.filter(fc);
                Assertions.assertNotNull(fc, "filterContext");
            }
            catch (FilterException efe) {
                this.abort(channel, future2, efe);
            }
        }
        if (fc.replayRequest() && future2.incrementRetryAndCheck() && future2.isReplayPossible()) {
            future2.setKeepAlive(false);
            this.replayRequest(future2, fc, channel);
            replayed = true;
        }
        return replayed;
    }

    public <T> void sendNextRequest(Request request2, NettyResponseFuture<T> future2) {
        this.sendRequest(request2, future2.getAsyncHandler(), future2);
    }

    private void validateWebSocketRequest(Request request2, AsyncHandler<?> asyncHandler) {
        Uri uri = request2.getUri();
        boolean isWs = uri.isWebSocket();
        if (asyncHandler instanceof WebSocketUpgradeHandler) {
            if (!isWs) {
                throw new IllegalArgumentException("WebSocketUpgradeHandler but scheme isn't ws or wss: " + uri.getScheme());
            }
            if (!request2.getMethod().equals(HttpConstants.Methods.GET) && !request2.getMethod().equals(HttpConstants.Methods.CONNECT)) {
                throw new IllegalArgumentException("WebSocketUpgradeHandler but method isn't GET or CONNECT: " + request2.getMethod());
            }
        } else if (isWs) {
            throw new IllegalArgumentException("No WebSocketUpgradeHandler but scheme is " + uri.getScheme());
        }
    }

    private Channel pollPooledChannel(Request request2, ProxyServer proxy, AsyncHandler<?> asyncHandler) {
        try {
            asyncHandler.onConnectionPoolAttempt();
        }
        catch (Exception e) {
            LOGGER.error("onConnectionPoolAttempt crashed", e);
        }
        Uri uri = request2.getUri();
        String virtualHost = request2.getVirtualHost();
        Channel channel = this.channelManager.poll(uri, virtualHost, proxy, request2.getChannelPoolPartitioning());
        if (channel != null) {
            LOGGER.debug("Using pooled Channel '{}' for '{}' to '{}'", channel, request2.getMethod(), uri);
        }
        return channel;
    }

    public void replayRequest(NettyResponseFuture<?> future2, FilterContext fc, Channel channel) {
        Request newRequest = fc.getRequest();
        future2.setAsyncHandler(fc.getAsyncHandler());
        future2.setChannelState(ChannelState.NEW);
        future2.touch();
        LOGGER.debug("\n\nReplaying Request {}\n for Future {}\n", (Object)newRequest, (Object)future2);
        try {
            future2.getAsyncHandler().onRetry();
        }
        catch (Exception e) {
            LOGGER.error("onRetry crashed", e);
            this.abort(channel, future2, e);
            return;
        }
        this.channelManager.drainChannelAndOffer(channel, future2);
        this.sendNextRequest(newRequest, future2);
    }

    public boolean isClosed() {
        return this.clientState.isClosed();
    }

    public void drainChannelAndExecuteNextRequest(Channel channel, NettyResponseFuture<?> future2, final Request nextRequest) {
        Channels.setAttribute(channel, new OnLastHttpContentCallback(future2){

            @Override
            public void call() {
                NettyRequestSender.this.sendNextRequest(nextRequest, this.future);
            }
        });
    }

    public void drainChannelAndExecuteNextRequest(Channel channel, NettyResponseFuture<?> future2, final Request nextRequest, final Future<Channel> whenHandshaked) {
        Channels.setAttribute(channel, new OnLastHttpContentCallback(future2){

            @Override
            public void call() {
                whenHandshaked.addListener(f2 -> {
                    if (f2.isSuccess()) {
                        NettyRequestSender.this.sendNextRequest(nextRequest, this.future);
                    } else {
                        this.future.abort(f2.cause());
                    }
                });
            }
        });
    }
}

