/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.request;

import java.nio.charset.Charset;
import java.util.Collection;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.Unpooled;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultFullHttpRequest;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpRequest;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderValues;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpMethod;
import play.shaded.ahc.io.netty.handler.codec.http.HttpVersion;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.io.netty.util.AsciiString;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequest;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyBody;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyBodyBody;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyByteArrayBody;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyByteBufferBody;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyCompositeByteArrayBody;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyDirectBody;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyFileBody;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyInputStreamBody;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyMultipartBody;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyReactiveStreamsBody;
import play.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.FileBodyGenerator;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.ReactiveStreamsBodyGenerator;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import play.shaded.ahc.org.asynchttpclient.util.AuthenticatorUtils;
import play.shaded.ahc.org.asynchttpclient.util.HttpUtils;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import play.shaded.ahc.org.asynchttpclient.util.StringUtils;
import play.shaded.ahc.org.asynchttpclient.ws.WebSocketUtils;

public final class NettyRequestFactory {
    private static final Integer ZERO_CONTENT_LENGTH = 0;
    private final AsyncHttpClientConfig config;
    private final ClientCookieEncoder cookieEncoder;

    NettyRequestFactory(AsyncHttpClientConfig config) {
        this.config = config;
        this.cookieEncoder = config.isUseLaxCookieEncoder() ? ClientCookieEncoder.LAX : ClientCookieEncoder.STRICT;
    }

    private NettyBody body(Request request2) {
        NettyBody nettyBody = null;
        Charset bodyCharset = request2.getCharset();
        if (request2.getByteData() != null) {
            nettyBody = new NettyByteArrayBody(request2.getByteData());
        } else if (request2.getCompositeByteData() != null) {
            nettyBody = new NettyCompositeByteArrayBody(request2.getCompositeByteData());
        } else if (request2.getStringData() != null) {
            nettyBody = new NettyByteBufferBody(StringUtils.charSequence2ByteBuffer(request2.getStringData(), bodyCharset));
        } else if (request2.getByteBufferData() != null) {
            nettyBody = new NettyByteBufferBody(request2.getByteBufferData());
        } else if (request2.getStreamData() != null) {
            nettyBody = new NettyInputStreamBody(request2.getStreamData());
        } else if (MiscUtils.isNonEmpty(request2.getFormParams())) {
            AsciiString contentTypeOverride = request2.getHeaders().contains(HttpHeaderNames.CONTENT_TYPE) ? null : HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED;
            nettyBody = new NettyByteBufferBody(HttpUtils.urlEncodeFormParams(request2.getFormParams(), bodyCharset), contentTypeOverride);
        } else if (MiscUtils.isNonEmpty(request2.getBodyParts())) {
            nettyBody = new NettyMultipartBody(request2.getBodyParts(), request2.getHeaders(), this.config);
        } else if (request2.getFile() != null) {
            nettyBody = new NettyFileBody(request2.getFile(), this.config);
        } else if (request2.getBodyGenerator() instanceof FileBodyGenerator) {
            FileBodyGenerator fileBodyGenerator = (FileBodyGenerator)request2.getBodyGenerator();
            nettyBody = new NettyFileBody(fileBodyGenerator.getFile(), fileBodyGenerator.getRegionSeek(), fileBodyGenerator.getRegionLength(), this.config);
        } else if (request2.getBodyGenerator() instanceof InputStreamBodyGenerator) {
            InputStreamBodyGenerator inStreamGenerator = (InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(request2.getBodyGenerator());
            nettyBody = new NettyInputStreamBody(inStreamGenerator.getInputStream(), inStreamGenerator.getContentLength());
        } else if (request2.getBodyGenerator() instanceof ReactiveStreamsBodyGenerator) {
            ReactiveStreamsBodyGenerator reactiveStreamsBodyGenerator = (ReactiveStreamsBodyGenerator)request2.getBodyGenerator();
            nettyBody = new NettyReactiveStreamsBody(reactiveStreamsBodyGenerator.getPublisher(), reactiveStreamsBodyGenerator.getContentLength());
        } else if (request2.getBodyGenerator() != null) {
            nettyBody = new NettyBodyBody(request2.getBodyGenerator().createBody(), this.config);
        }
        return nettyBody;
    }

    public void addAuthorizationHeader(HttpHeaders headers, String authorizationHeader) {
        if (authorizationHeader != null) {
            headers.add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)authorizationHeader);
        }
    }

    public void setProxyAuthorizationHeader(HttpHeaders headers, String proxyAuthorizationHeader) {
        if (proxyAuthorizationHeader != null) {
            headers.set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)proxyAuthorizationHeader);
        }
    }

    public NettyRequest newNettyRequest(Request request2, boolean performConnectRequest, ProxyServer proxyServer, Realm realm, Realm proxyRealm) {
        CharSequence connectionHeaderValue;
        NettyRequest nettyRequest;
        DefaultHttpRequest httpRequest;
        NettyBody body2;
        Uri uri = request2.getUri();
        HttpMethod method2 = performConnectRequest ? HttpMethod.CONNECT : HttpMethod.valueOf(request2.getMethod());
        boolean connect = method2 == HttpMethod.CONNECT;
        HttpVersion httpVersion = HttpVersion.HTTP_1_1;
        String requestUri = this.requestUri(uri, proxyServer, connect);
        NettyBody nettyBody = body2 = connect ? null : this.body(request2);
        if (body2 == null) {
            httpRequest = new DefaultFullHttpRequest(httpVersion, method2, requestUri, Unpooled.EMPTY_BUFFER);
            nettyRequest = new NettyRequest(httpRequest, null);
        } else if (body2 instanceof NettyDirectBody) {
            ByteBuf buf = ((NettyDirectBody)NettyDirectBody.class.cast(body2)).byteBuf();
            DefaultFullHttpRequest httpRequest2 = new DefaultFullHttpRequest(httpVersion, method2, requestUri, buf);
            nettyRequest = new NettyRequest(httpRequest2, null);
        } else {
            httpRequest = new DefaultHttpRequest(httpVersion, method2, requestUri);
            nettyRequest = new NettyRequest(httpRequest, body2);
        }
        HttpHeaders headers = nettyRequest.getHttpRequest().headers();
        if (connect) {
            headers.set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, request2.getHeaders().getAll(HttpHeaderNames.PROXY_AUTHORIZATION));
        } else {
            String userDefinedAcceptEncoding;
            headers.set(request2.getHeaders());
            if (MiscUtils.isNonEmpty(request2.getCookies())) {
                headers.set((CharSequence)HttpHeaderNames.COOKIE, (Object)this.cookieEncoder.encode((Collection<? extends Cookie>)request2.getCookies()));
            }
            if ((userDefinedAcceptEncoding = headers.get(HttpHeaderNames.ACCEPT_ENCODING)) != null) {
                headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpUtils.filterOutBrotliFromAcceptEncoding(userDefinedAcceptEncoding));
            } else if (this.config.isCompressionEnforced()) {
                headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpUtils.GZIP_DEFLATE);
            }
        }
        if (!headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
            if (body2 != null) {
                if (body2.getContentLength() < 0L) {
                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                } else {
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body2.getContentLength());
                }
            } else if (method2 == HttpMethod.POST || method2 == HttpMethod.PUT || method2 == HttpMethod.PATCH) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)ZERO_CONTENT_LENGTH);
            }
        }
        if (body2 != null && body2.getContentTypeOverride() != null) {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)body2.getContentTypeOverride());
        }
        if (!connect && uri.isWebSocket()) {
            headers.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)WebSocketUtils.getWebSocketKey()).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"13");
            if (!headers.contains(HttpHeaderNames.ORIGIN)) {
                headers.set((CharSequence)HttpHeaderNames.ORIGIN, (Object)HttpUtils.originHeader(uri));
            }
        } else if (!headers.contains(HttpHeaderNames.CONNECTION) && (connectionHeaderValue = this.connectionHeader(this.config.isKeepAlive(), httpVersion)) != null) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)connectionHeaderValue);
        }
        if (!headers.contains(HttpHeaderNames.HOST)) {
            String virtualHost = request2.getVirtualHost();
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)(virtualHost != null ? virtualHost : HttpUtils.hostHeader(uri)));
        }
        this.addAuthorizationHeader(headers, AuthenticatorUtils.perRequestAuthorizationHeader(request2, realm));
        if (!uri.isSecured() || connect) {
            this.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perRequestProxyAuthorizationHeader(request2, proxyRealm));
        }
        if (!headers.contains(HttpHeaderNames.ACCEPT)) {
            headers.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)HttpUtils.ACCEPT_ALL_HEADER_VALUE);
        }
        if (!headers.contains(HttpHeaderNames.USER_AGENT) && this.config.getUserAgent() != null) {
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.config.getUserAgent());
        }
        return nettyRequest;
    }

    private String requestUri(Uri uri, ProxyServer proxyServer, boolean connect) {
        if (connect) {
            return uri.getAuthority();
        }
        if (proxyServer != null && !uri.isSecured() && proxyServer.getProxyType().isHttp()) {
            return uri.toUrl();
        }
        return uri.toRelativeUrl();
    }

    private CharSequence connectionHeader(boolean keepAlive2, HttpVersion httpVersion) {
        if (httpVersion.isKeepAliveDefault()) {
            return keepAlive2 ? null : HttpHeaderValues.CLOSE;
        }
        return keepAlive2 ? HttpHeaderValues.KEEP_ALIVE : null;
    }
}

