/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.handler.intercept;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpRequest;
import play.shaded.ahc.io.netty.handler.codec.http.HttpResponse;
import play.shaded.ahc.io.netty.handler.codec.http.HttpUtil;
import play.shaded.ahc.org.asynchttpclient.Dsl;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.RequestBuilder;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelManager;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelState;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import play.shaded.ahc.org.asynchttpclient.ntlm.NtlmEngine;
import play.shaded.ahc.org.asynchttpclient.spnego.SpnegoEngine;
import play.shaded.ahc.org.asynchttpclient.spnego.SpnegoEngineException;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import play.shaded.ahc.org.asynchttpclient.util.AuthenticatorUtils;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;

public class Unauthorized401Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Unauthorized401Interceptor.class);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;

    Unauthorized401Interceptor(ChannelManager channelManager, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.requestSender = requestSender;
    }

    public boolean exitAfterHandling401(Channel channel, NettyResponseFuture<?> future2, HttpResponse response, Request request2, Realm realm, HttpRequest httpRequest) {
        if (realm == null) {
            LOGGER.debug("Can't handle 401 as there's no realm");
            return false;
        }
        if (future2.isAndSetInAuth(true)) {
            LOGGER.info("Can't handle 401 as auth was already performed");
            return false;
        }
        List<String> wwwAuthHeaders = response.headers().getAll(HttpHeaderNames.WWW_AUTHENTICATE);
        if (wwwAuthHeaders.isEmpty()) {
            LOGGER.info("Can't handle 401 as response doesn't contain WWW-Authenticate headers");
            return false;
        }
        future2.setChannelState(ChannelState.NEW);
        HttpHeaders requestHeaders = new DefaultHttpHeaders(false).add(request2.getHeaders());
        switch (realm.getScheme()) {
            case BASIC: {
                if (AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "Basic") == null) {
                    LOGGER.info("Can't handle 401 with Basic realm as WWW-Authenticate headers don't match");
                    return false;
                }
                if (realm.isUsePreemptiveAuth()) {
                    LOGGER.info("Can't handle 401 with Basic realm as auth was preemptive and already performed");
                    return false;
                }
                Realm newBasicRealm = Dsl.realm(realm).setUsePreemptiveAuth(true).build();
                future2.setRealm(newBasicRealm);
                break;
            }
            case DIGEST: {
                String digestHeader = AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "Digest");
                if (digestHeader == null) {
                    LOGGER.info("Can't handle 401 with Digest realm as WWW-Authenticate headers don't match");
                    return false;
                }
                Realm newDigestRealm = Dsl.realm(realm).setUri(request2.getUri()).setMethodName(request2.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(digestHeader).build();
                future2.setRealm(newDigestRealm);
                break;
            }
            case NTLM: {
                String ntlmHeader = AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "NTLM");
                if (ntlmHeader == null) {
                    LOGGER.info("Can't handle 401 with NTLM realm as WWW-Authenticate headers don't match");
                    return false;
                }
                this.ntlmChallenge(ntlmHeader, requestHeaders, realm, future2);
                Realm newNtlmRealm = Dsl.realm(realm).setUsePreemptiveAuth(true).build();
                future2.setRealm(newNtlmRealm);
                break;
            }
            case KERBEROS: 
            case SPNEGO: {
                if (AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "Negotiate") == null) {
                    LOGGER.info("Can't handle 401 with Kerberos or Spnego realm as WWW-Authenticate headers don't match");
                    return false;
                }
                try {
                    this.kerberosChallenge(realm, request2, requestHeaders);
                    break;
                }
                catch (SpnegoEngineException e) {
                    String ntlmHeader2 = AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "NTLM");
                    if (ntlmHeader2 != null) {
                        LOGGER.warn("Kerberos/Spnego auth failed, proceeding with NTLM");
                        this.ntlmChallenge(ntlmHeader2, requestHeaders, realm, future2);
                        Realm newNtlmRealm2 = Dsl.realm(realm).setScheme(Realm.AuthScheme.NTLM).setUsePreemptiveAuth(true).build();
                        future2.setRealm(newNtlmRealm2);
                        break;
                    }
                    this.requestSender.abort(channel, future2, e);
                    return false;
                }
            }
            default: {
                throw new IllegalStateException("Invalid Authentication scheme " + (Object)((Object)realm.getScheme()));
            }
        }
        Request nextRequest = ((RequestBuilder)new RequestBuilder(future2.getCurrentRequest()).setHeaders(requestHeaders)).build();
        LOGGER.debug("Sending authentication to {}", (Object)request2.getUri());
        if (future2.isKeepAlive() && !HttpUtil.isTransferEncodingChunked(httpRequest) && !HttpUtil.isTransferEncodingChunked(response)) {
            future2.setReuseChannel(true);
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future2, nextRequest);
        } else {
            this.channelManager.closeChannel(channel);
            this.requestSender.sendNextRequest(nextRequest, future2);
        }
        return true;
    }

    private void ntlmChallenge(String authenticateHeader, HttpHeaders requestHeaders, Realm realm, NettyResponseFuture<?> future2) {
        if (authenticateHeader.equals("NTLM")) {
            String challengeHeader = NtlmEngine.INSTANCE.generateType1Msg();
            requestHeaders.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)("NTLM " + challengeHeader));
            future2.setInAuth(false);
        } else {
            String serverChallenge = authenticateHeader.substring("NTLM ".length()).trim();
            String challengeHeader = NtlmEngine.INSTANCE.generateType3Msg(realm.getPrincipal(), realm.getPassword(), realm.getNtlmDomain(), realm.getNtlmHost(), serverChallenge);
            requestHeaders.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)("NTLM " + challengeHeader));
        }
    }

    private void kerberosChallenge(Realm realm, Request request2, HttpHeaders headers) throws SpnegoEngineException {
        Uri uri = request2.getUri();
        String host = MiscUtils.withDefault(request2.getVirtualHost(), uri.getHost());
        String challengeHeader = SpnegoEngine.instance(realm.getPrincipal(), realm.getPassword(), realm.getServicePrincipalName(), realm.getRealmName(), realm.isUseCanonicalHostname(), realm.getCustomLoginConfig(), realm.getLoginContextName()).generateToken(host);
        headers.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)("Negotiate " + challengeHeader));
    }
}

