/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.handler.intercept;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpResponse;
import play.shaded.ahc.io.netty.handler.codec.http.HttpUtil;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.RequestBuilder;
import play.shaded.ahc.org.asynchttpclient.cookie.CookieStore;
import play.shaded.ahc.org.asynchttpclient.handler.MaxRedirectException;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelManager;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import play.shaded.ahc.org.asynchttpclient.util.HttpConstants;
import play.shaded.ahc.org.asynchttpclient.util.HttpUtils;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import play.shaded.ahc.org.asynchttpclient.util.ThrowableUtil;

public class Redirect30xInterceptor {
    public static final Set<Integer> REDIRECT_STATUSES = new HashSet<Integer>();
    private static final Logger LOGGER = LoggerFactory.getLogger(Redirect30xInterceptor.class);
    private final ChannelManager channelManager;
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;
    private final MaxRedirectException maxRedirectException;

    Redirect30xInterceptor(ChannelManager channelManager, AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.config = config;
        this.requestSender = requestSender;
        this.maxRedirectException = ThrowableUtil.unknownStackTrace(new MaxRedirectException("Maximum redirect reached: " + config.getMaxRedirects()), Redirect30xInterceptor.class, "exitAfterHandlingRedirect");
    }

    public boolean exitAfterHandlingRedirect(Channel channel, NettyResponseFuture<?> future2, HttpResponse response, Request request2, int statusCode, Realm realm) throws Exception {
        if (HttpUtils.followRedirect(this.config, request2)) {
            boolean sameBase;
            List<Cookie> cookies2;
            if (future2.incrementAndGetCurrentRedirectCount() >= this.config.getMaxRedirects()) {
                throw this.maxRedirectException;
            }
            future2.setInAuth(false);
            future2.setInProxyAuth(false);
            String originalMethod = request2.getMethod();
            boolean switchToGet = !originalMethod.equals(HttpConstants.Methods.GET) && (statusCode == HttpConstants.ResponseStatusCodes.MOVED_PERMANENTLY_301 || statusCode == HttpConstants.ResponseStatusCodes.SEE_OTHER_303 || statusCode == HttpConstants.ResponseStatusCodes.FOUND_302 && !this.config.isStrict302Handling());
            boolean keepBody = statusCode == HttpConstants.ResponseStatusCodes.TEMPORARY_REDIRECT_307 || statusCode == HttpConstants.ResponseStatusCodes.PERMANENT_REDIRECT_308 || statusCode == HttpConstants.ResponseStatusCodes.FOUND_302 && this.config.isStrict302Handling();
            RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder(switchToGet ? HttpConstants.Methods.GET : originalMethod).setChannelPoolPartitioning(request2.getChannelPoolPartitioning())).setFollowRedirect(true)).setLocalAddress(request2.getLocalAddress())).setNameResolver(request2.getNameResolver())).setProxyServer(request2.getProxyServer())).setRealm(request2.getRealm())).setRequestTimeout(request2.getRequestTimeout());
            if (keepBody) {
                requestBuilder.setCharset(request2.getCharset());
                if (MiscUtils.isNonEmpty(request2.getFormParams())) {
                    requestBuilder.setFormParams(request2.getFormParams());
                } else if (request2.getStringData() != null) {
                    requestBuilder.setBody(request2.getStringData());
                } else if (request2.getByteData() != null) {
                    requestBuilder.setBody(request2.getByteData());
                } else if (request2.getByteBufferData() != null) {
                    requestBuilder.setBody(request2.getByteBufferData());
                } else if (request2.getBodyGenerator() != null) {
                    requestBuilder.setBody(request2.getBodyGenerator());
                }
            }
            requestBuilder.setHeaders(this.propagatedHeaders(request2, realm, keepBody));
            boolean initialConnectionKeepAlive = future2.isKeepAlive();
            Object initialPartitionKey = future2.getPartitionKey();
            HttpHeaders responseHeaders = response.headers();
            String location = responseHeaders.get(HttpHeaderNames.LOCATION);
            Uri newUri = Uri.create(future2.getUri(), location);
            LOGGER.debug("Redirecting to {}", (Object)newUri);
            CookieStore cookieStore = this.config.getCookieStore();
            if (cookieStore != null && !(cookies2 = cookieStore.get(newUri)).isEmpty()) {
                for (Cookie cookie2 : cookies2) {
                    requestBuilder.addOrReplaceCookie(cookie2);
                }
            }
            if (sameBase = request2.getUri().isSameBase(newUri)) {
                requestBuilder.setVirtualHost(request2.getVirtualHost());
            }
            Request nextRequest = ((RequestBuilder)requestBuilder.setUri(newUri)).build();
            future2.setTargetRequest(nextRequest);
            LOGGER.debug("Sending redirect to {}", (Object)newUri);
            if (future2.isKeepAlive() && !HttpUtil.isTransferEncodingChunked(response)) {
                if (sameBase) {
                    future2.setReuseChannel(true);
                    this.requestSender.drainChannelAndExecuteNextRequest(channel, future2, nextRequest);
                } else {
                    this.channelManager.drainChannelAndOffer(channel, future2, initialConnectionKeepAlive, initialPartitionKey);
                    this.requestSender.sendNextRequest(nextRequest, future2);
                }
            } else {
                this.channelManager.closeChannel(channel);
                this.requestSender.sendNextRequest(nextRequest, future2);
            }
            return true;
        }
        return false;
    }

    private HttpHeaders propagatedHeaders(Request request2, Realm realm, boolean keepBody) {
        HttpHeaders headers = request2.getHeaders().remove(HttpHeaderNames.HOST).remove(HttpHeaderNames.CONTENT_LENGTH);
        if (!keepBody) {
            headers.remove(HttpHeaderNames.CONTENT_TYPE);
        }
        if (realm != null && realm.getScheme() == Realm.AuthScheme.NTLM) {
            headers.remove(HttpHeaderNames.AUTHORIZATION).remove(HttpHeaderNames.PROXY_AUTHORIZATION);
        }
        return headers;
    }

    static {
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.MOVED_PERMANENTLY_301);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.FOUND_302);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.SEE_OTHER_303);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.TEMPORARY_REDIRECT_307);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.PERMANENT_REDIRECT_308);
    }
}

