/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.handler.intercept;

import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpMethod;
import play.shaded.ahc.io.netty.handler.codec.http.HttpRequest;
import play.shaded.ahc.io.netty.handler.codec.http.HttpResponse;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.cookie.CookieStore;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelManager;
import play.shaded.ahc.org.asynchttpclient.netty.handler.intercept.ConnectSuccessInterceptor;
import play.shaded.ahc.org.asynchttpclient.netty.handler.intercept.Continue100Interceptor;
import play.shaded.ahc.org.asynchttpclient.netty.handler.intercept.ProxyUnauthorized407Interceptor;
import play.shaded.ahc.org.asynchttpclient.netty.handler.intercept.Redirect30xInterceptor;
import play.shaded.ahc.org.asynchttpclient.netty.handler.intercept.ResponseFiltersInterceptor;
import play.shaded.ahc.org.asynchttpclient.netty.handler.intercept.Unauthorized401Interceptor;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import play.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import play.shaded.ahc.org.asynchttpclient.util.HttpConstants;

public class Interceptors {
    private final AsyncHttpClientConfig config;
    private final Unauthorized401Interceptor unauthorized401Interceptor;
    private final ProxyUnauthorized407Interceptor proxyUnauthorized407Interceptor;
    private final Continue100Interceptor continue100Interceptor;
    private final Redirect30xInterceptor redirect30xInterceptor;
    private final ConnectSuccessInterceptor connectSuccessInterceptor;
    private final ResponseFiltersInterceptor responseFiltersInterceptor;
    private final boolean hasResponseFilters;
    private final ClientCookieDecoder cookieDecoder;

    public Interceptors(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        this.config = config;
        this.unauthorized401Interceptor = new Unauthorized401Interceptor(channelManager, requestSender);
        this.proxyUnauthorized407Interceptor = new ProxyUnauthorized407Interceptor(channelManager, requestSender);
        this.continue100Interceptor = new Continue100Interceptor(requestSender);
        this.redirect30xInterceptor = new Redirect30xInterceptor(channelManager, config, requestSender);
        this.connectSuccessInterceptor = new ConnectSuccessInterceptor(channelManager, requestSender);
        this.responseFiltersInterceptor = new ResponseFiltersInterceptor(config, requestSender);
        this.hasResponseFilters = !config.getResponseFilters().isEmpty();
        this.cookieDecoder = config.isUseLaxCookieEncoder() ? ClientCookieDecoder.LAX : ClientCookieDecoder.STRICT;
    }

    public boolean exitAfterIntercept(Channel channel, NettyResponseFuture<?> future2, AsyncHandler<?> handler, HttpResponse response, HttpResponseStatus status, HttpHeaders responseHeaders) throws Exception {
        HttpRequest httpRequest = future2.getNettyRequest().getHttpRequest();
        ProxyServer proxyServer = future2.getProxyServer();
        int statusCode = response.status().code();
        Request request2 = future2.getCurrentRequest();
        Realm realm = request2.getRealm() != null ? request2.getRealm() : this.config.getRealm();
        CookieStore cookieStore = this.config.getCookieStore();
        if (cookieStore != null) {
            for (String cookieStr : responseHeaders.getAll(HttpHeaderNames.SET_COOKIE)) {
                Cookie c = this.cookieDecoder.decode(cookieStr);
                if (c == null) continue;
                cookieStore.add(future2.getCurrentRequest().getUri(), c);
            }
        }
        if (this.hasResponseFilters && this.responseFiltersInterceptor.exitAfterProcessingFilters(channel, future2, handler, status, responseHeaders)) {
            return true;
        }
        if (statusCode == HttpConstants.ResponseStatusCodes.UNAUTHORIZED_401) {
            return this.unauthorized401Interceptor.exitAfterHandling401(channel, future2, response, request2, realm, httpRequest);
        }
        if (statusCode == HttpConstants.ResponseStatusCodes.PROXY_AUTHENTICATION_REQUIRED_407) {
            return this.proxyUnauthorized407Interceptor.exitAfterHandling407(channel, future2, response, request2, proxyServer, httpRequest);
        }
        if (statusCode == HttpConstants.ResponseStatusCodes.CONTINUE_100) {
            return this.continue100Interceptor.exitAfterHandling100(channel, future2);
        }
        if (Redirect30xInterceptor.REDIRECT_STATUSES.contains(statusCode)) {
            return this.redirect30xInterceptor.exitAfterHandlingRedirect(channel, future2, response, request2, statusCode, realm);
        }
        if (httpRequest.method() == HttpMethod.CONNECT && statusCode == HttpConstants.ResponseStatusCodes.OK_200) {
            return this.connectSuccessInterceptor.exitAfterHandlingConnect(channel, future2, request2, proxyServer);
        }
        return false;
    }
}

