/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.handler;

import java.io.IOException;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelHandler;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderValues;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpRequest;
import play.shaded.ahc.io.netty.handler.codec.http.HttpResponse;
import play.shaded.ahc.io.netty.handler.codec.http.LastHttpContent;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseStatus;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelManager;
import play.shaded.ahc.org.asynchttpclient.netty.channel.Channels;
import play.shaded.ahc.org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import play.shaded.ahc.org.asynchttpclient.netty.ws.NettyWebSocket;
import play.shaded.ahc.org.asynchttpclient.ws.WebSocketUpgradeHandler;
import play.shaded.ahc.org.asynchttpclient.ws.WebSocketUtils;

@ChannelHandler.Sharable
public final class WebSocketHandler
extends AsyncHttpClientHandler {
    public WebSocketHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        super(config, channelManager, requestSender);
    }

    private static WebSocketUpgradeHandler getWebSocketUpgradeHandler(NettyResponseFuture<?> future2) {
        return (WebSocketUpgradeHandler)future2.getAsyncHandler();
    }

    private static NettyWebSocket getNettyWebSocket(NettyResponseFuture<?> future2) throws Exception {
        return WebSocketHandler.getWebSocketUpgradeHandler(future2).onCompleted();
    }

    private void upgrade(Channel channel, NettyResponseFuture<?> future2, WebSocketUpgradeHandler handler, HttpResponse response, HttpHeaders responseHeaders) throws Exception {
        boolean headerOK;
        boolean validStatus = response.status().equals(play.shaded.ahc.io.netty.handler.codec.http.HttpResponseStatus.SWITCHING_PROTOCOLS);
        boolean validUpgrade = response.headers().get(HttpHeaderNames.UPGRADE) != null;
        String connection = response.headers().get(HttpHeaderNames.CONNECTION);
        boolean validConnection = HttpHeaderValues.UPGRADE.contentEqualsIgnoreCase(connection);
        boolean bl = headerOK = handler.onHeadersReceived(responseHeaders) == AsyncHandler.State.CONTINUE;
        if (!(headerOK && validStatus && validUpgrade && validConnection)) {
            this.requestSender.abort(channel, future2, new IOException("Invalid handshake response"));
            return;
        }
        String accept2 = response.headers().get(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
        String key = WebSocketUtils.getAcceptKey(future2.getNettyRequest().getHttpRequest().headers().get(HttpHeaderNames.SEC_WEBSOCKET_KEY));
        if (accept2 == null || !accept2.equals(key)) {
            this.requestSender.abort(channel, future2, new IOException("Invalid challenge. Actual: " + accept2 + ". Expected: " + key));
        }
        Channels.setAttribute(channel, future2);
        handler.setWebSocket(new NettyWebSocket(channel, responseHeaders));
        this.channelManager.upgradePipelineForWebSockets(channel.pipeline());
        try {
            handler.onOpen();
        }
        catch (Exception ex) {
            this.logger.warn("onSuccess unexpected exception", ex);
        }
        future2.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort(Channel channel, NettyResponseFuture<?> future2, WebSocketUpgradeHandler handler, HttpResponseStatus status) {
        try {
            handler.onThrowable(new IOException("Invalid Status code=" + status.getStatusCode() + " text=" + status.getStatusText()));
        }
        finally {
            this.finishUpdate(future2, channel, true);
        }
    }

    @Override
    public void handleRead(Channel channel, NettyResponseFuture<?> future2, Object e) throws Exception {
        if (e instanceof HttpResponse) {
            HttpHeaders responseHeaders;
            NettyResponseStatus status;
            WebSocketUpgradeHandler handler;
            HttpResponse response = (HttpResponse)e;
            if (this.logger.isDebugEnabled()) {
                HttpRequest httpRequest = future2.getNettyRequest().getHttpRequest();
                this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
            }
            if (!this.interceptors.exitAfterIntercept(channel, future2, handler = WebSocketHandler.getWebSocketUpgradeHandler(future2), response, status = new NettyResponseStatus(future2.getUri(), response, channel), responseHeaders = response.headers())) {
                switch (handler.onStatusReceived(status)) {
                    case CONTINUE: {
                        this.upgrade(channel, future2, handler, response, responseHeaders);
                        break;
                    }
                    default: {
                        this.abort(channel, future2, handler, status);
                    }
                }
            }
        } else if (e instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)e;
            NettyWebSocket webSocket = WebSocketHandler.getNettyWebSocket(future2);
            if (webSocket.isReady()) {
                webSocket.handleFrame(frame);
            } else {
                webSocket.bufferFrame(frame);
            }
        } else if (!(e instanceof LastHttpContent)) {
            this.logger.error("Invalid message {}", e);
        }
    }

    @Override
    public void handleException(NettyResponseFuture<?> future2, Throwable e) {
        this.logger.warn("onError", e);
        try {
            NettyWebSocket webSocket = WebSocketHandler.getNettyWebSocket(future2);
            if (webSocket != null) {
                webSocket.onError(e);
                webSocket.sendCloseFrame();
            }
        }
        catch (Throwable t) {
            this.logger.error("onError", t);
        }
    }

    @Override
    public void handleChannelInactive(NettyResponseFuture<?> future2) {
        this.logger.trace("Connection was closed abnormally (that is, with no close frame being received).");
        try {
            NettyWebSocket webSocket = WebSocketHandler.getNettyWebSocket(future2);
            if (webSocket != null) {
                webSocket.onClose(1006, "Connection was closed abnormally (that is, with no close frame being received).");
            }
        }
        catch (Throwable t) {
            this.logger.error("onError", t);
        }
    }
}

