/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.handler;

import java.io.IOException;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelHandler;
import play.shaded.ahc.io.netty.handler.codec.DecoderResultProvider;
import play.shaded.ahc.io.netty.handler.codec.http.HttpContent;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpRequest;
import play.shaded.ahc.io.netty.handler.codec.http.HttpResponse;
import play.shaded.ahc.io.netty.handler.codec.http.LastHttpContent;
import play.shaded.ahc.io.netty.util.concurrent.EventExecutorGroup;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.handler.StreamedAsyncHandler;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseStatus;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelManager;
import play.shaded.ahc.org.asynchttpclient.netty.channel.Channels;
import play.shaded.ahc.org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import play.shaded.ahc.org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;

@ChannelHandler.Sharable
public final class HttpHandler
extends AsyncHttpClientHandler {
    public HttpHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        super(config, channelManager, requestSender);
    }

    private boolean abortAfterHandlingStatus(AsyncHandler<?> handler, NettyResponseStatus status) throws Exception {
        return handler.onStatusReceived(status) == AsyncHandler.State.ABORT;
    }

    private boolean abortAfterHandlingHeaders(AsyncHandler<?> handler, HttpHeaders responseHeaders) throws Exception {
        return !responseHeaders.isEmpty() && handler.onHeadersReceived(responseHeaders) == AsyncHandler.State.ABORT;
    }

    private boolean abortAfterHandlingReactiveStreams(Channel channel, NettyResponseFuture<?> future2, AsyncHandler<?> handler) {
        if (handler instanceof StreamedAsyncHandler) {
            StreamedAsyncHandler streamedAsyncHandler = (StreamedAsyncHandler)handler;
            StreamedResponsePublisher publisher = new StreamedResponsePublisher(channel.eventLoop(), this.channelManager, future2, channel);
            channel.pipeline().addLast((EventExecutorGroup)channel.eventLoop(), "streamedAsyncHandler", (ChannelHandler)publisher);
            Channels.setAttribute(channel, publisher);
            return streamedAsyncHandler.onStream(publisher) == AsyncHandler.State.ABORT;
        }
        return false;
    }

    private void handleHttpResponse(HttpResponse response, Channel channel, NettyResponseFuture<?> future2, AsyncHandler<?> handler) throws Exception {
        HttpRequest httpRequest = future2.getNettyRequest().getHttpRequest();
        this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
        future2.setKeepAlive(this.config.getKeepAliveStrategy().keepAlive(future2.getTargetRequest(), httpRequest, response));
        NettyResponseStatus status = new NettyResponseStatus(future2.getUri(), response, channel);
        HttpHeaders responseHeaders = response.headers();
        if (!this.interceptors.exitAfterIntercept(channel, future2, handler, response, status, responseHeaders)) {
            boolean abort;
            boolean bl = abort = this.abortAfterHandlingStatus(handler, status) || this.abortAfterHandlingHeaders(handler, responseHeaders) || this.abortAfterHandlingReactiveStreams(channel, future2, handler);
            if (abort) {
                this.finishUpdate(future2, channel, true);
            }
        }
    }

    private void handleChunk(HttpContent chunk, Channel channel, NettyResponseFuture<?> future2, AsyncHandler<?> handler) throws Exception {
        LastHttpContent lastChunk;
        HttpHeaders trailingHeaders;
        boolean abort = false;
        boolean last2 = chunk instanceof LastHttpContent;
        if (last2 && !(trailingHeaders = (lastChunk = (LastHttpContent)chunk).trailingHeaders()).isEmpty()) {
            abort = handler.onTrailingHeadersReceived(trailingHeaders) == AsyncHandler.State.ABORT;
        }
        ByteBuf buf = chunk.content();
        if (!abort && !(handler instanceof StreamedAsyncHandler) && (buf.isReadable() || last2)) {
            HttpResponseBodyPart bodyPart = this.config.getResponseBodyPartFactory().newResponseBodyPart(buf, last2);
            boolean bl = abort = handler.onBodyPartReceived(bodyPart) == AsyncHandler.State.ABORT;
        }
        if (abort || last2) {
            boolean close2 = abort || !future2.isKeepAlive();
            this.finishUpdate(future2, channel, close2);
        }
    }

    @Override
    public void handleRead(Channel channel, NettyResponseFuture<?> future2, Object e) throws Exception {
        if (future2.isDone()) {
            this.channelManager.closeChannel(channel);
            return;
        }
        AsyncHandler<?> handler = future2.getAsyncHandler();
        try {
            DecoderResultProvider object;
            Throwable t;
            if (e instanceof DecoderResultProvider && (t = (object = (DecoderResultProvider)e).decoderResult().cause()) != null) {
                this.readFailed(channel, future2, t);
                return;
            }
            if (e instanceof HttpResponse) {
                this.handleHttpResponse((HttpResponse)e, channel, future2, handler);
            } else if (e instanceof HttpContent) {
                this.handleChunk((HttpContent)e, channel, future2, handler);
            }
        }
        catch (Exception t) {
            if (this.hasIOExceptionFilters && t instanceof IOException && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future2, (IOException)t, channel)) {
                return;
            }
            this.readFailed(channel, future2, t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFailed(Channel channel, NettyResponseFuture<?> future2, Throwable t) {
        try {
            this.requestSender.abort(channel, future2, t);
        }
        catch (Exception abortException) {
            this.logger.debug("Abort failed", abortException);
        }
        finally {
            this.finishUpdate(future2, channel, true);
        }
    }

    @Override
    public void handleException(NettyResponseFuture<?> future2, Throwable error2) {
    }

    @Override
    public void handleChannelInactive(NettyResponseFuture<?> future2) {
    }
}

