/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.handler;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.channel.ChannelInboundHandlerAdapter;
import play.shaded.ahc.io.netty.handler.codec.PrematureChannelClosureException;
import play.shaded.ahc.io.netty.handler.codec.http.HttpContent;
import play.shaded.ahc.io.netty.handler.codec.http.LastHttpContent;
import play.shaded.ahc.io.netty.util.ReferenceCountUtil;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.exception.ChannelClosedException;
import play.shaded.ahc.org.asynchttpclient.netty.DiscardEvent;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.OnLastHttpContentCallback;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelManager;
import play.shaded.ahc.org.asynchttpclient.netty.channel.Channels;
import play.shaded.ahc.org.asynchttpclient.netty.future.StackTraceInspector;
import play.shaded.ahc.org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import play.shaded.ahc.org.asynchttpclient.netty.handler.intercept.Interceptors;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;

public abstract class AsyncHttpClientHandler
extends ChannelInboundHandlerAdapter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final AsyncHttpClientConfig config;
    protected final ChannelManager channelManager;
    protected final NettyRequestSender requestSender;
    final Interceptors interceptors;
    final boolean hasIOExceptionFilters;

    AsyncHttpClientHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        this.config = config;
        this.channelManager = channelManager;
        this.requestSender = requestSender;
        this.interceptors = new Interceptors(config, channelManager, requestSender);
        this.hasIOExceptionFilters = !config.getIoExceptionFilters().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel channel = ctx.channel();
        Object attribute2 = Channels.getAttribute(channel);
        try {
            if (attribute2 instanceof OnLastHttpContentCallback) {
                if (msg instanceof LastHttpContent) {
                    ((OnLastHttpContentCallback)attribute2).call();
                }
            } else if (attribute2 instanceof NettyResponseFuture) {
                NettyResponseFuture future2 = (NettyResponseFuture)attribute2;
                future2.touch();
                this.handleRead(channel, future2, msg);
            } else if (attribute2 instanceof StreamedResponsePublisher) {
                StreamedResponsePublisher publisher = (StreamedResponsePublisher)attribute2;
                publisher.future().touch();
                if (msg instanceof HttpContent) {
                    ByteBuf content = ((HttpContent)msg).content();
                    if (content.isReadable()) {
                        HttpResponseBodyPart part = this.config.getResponseBodyPartFactory().newResponseBodyPart(content, false);
                        ctx.fireChannelRead(part);
                    }
                    if (msg instanceof LastHttpContent) {
                        ctx.pipeline().remove(publisher);
                        ctx.read();
                        this.handleRead(channel, publisher.future(), msg);
                    }
                } else {
                    this.logger.info("Received unexpected message while expecting a chunk: " + msg);
                    ctx.pipeline().remove(publisher);
                    Channels.setDiscard(channel);
                }
            } else if (attribute2 != DiscardEvent.DISCARD) {
                this.logger.debug("Orphan channel {} with attribute {} received message {}, closing", channel, attribute2, msg);
                Channels.silentlyCloseChannel(channel);
            }
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.requestSender.isClosed()) {
            return;
        }
        Channel channel = ctx.channel();
        this.channelManager.removeAll(channel);
        NettyResponseFuture<?> attribute2 = Channels.getAttribute(channel);
        this.logger.debug("Channel Closed: {} with attribute {}", (Object)channel, (Object)attribute2);
        if (attribute2 instanceof StreamedResponsePublisher) {
            attribute2 = ((StreamedResponsePublisher)((Object)attribute2)).future();
        }
        if (attribute2 instanceof OnLastHttpContentCallback) {
            OnLastHttpContentCallback callback = (OnLastHttpContentCallback)((Object)attribute2);
            Channels.setAttribute(channel, callback.future());
            callback.call();
        } else if (attribute2 instanceof NettyResponseFuture) {
            NettyResponseFuture<?> future2 = attribute2;
            future2.touch();
            if (this.hasIOExceptionFilters && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future2, ChannelClosedException.INSTANCE, channel)) {
                return;
            }
            this.handleChannelInactive(future2);
            this.requestSender.handleUnexpectedClosedChannel(channel, future2);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        Throwable cause = MiscUtils.getCause(e);
        if (cause instanceof PrematureChannelClosureException || cause instanceof ClosedChannelException) {
            return;
        }
        Channel channel = ctx.channel();
        NettyResponseFuture<?> future2 = null;
        this.logger.debug("Unexpected I/O exception on channel {}", (Object)channel, (Object)cause);
        try {
            NettyResponseFuture<?> attribute2 = Channels.getAttribute(channel);
            if (attribute2 instanceof StreamedResponsePublisher) {
                ctx.fireExceptionCaught(e);
                attribute2 = ((StreamedResponsePublisher)((Object)attribute2)).future();
            }
            if (attribute2 instanceof NettyResponseFuture) {
                future2 = attribute2;
                future2.attachChannel(null, false);
                future2.touch();
                if (cause instanceof IOException && this.hasIOExceptionFilters) {
                    if (!this.requestSender.applyIoExceptionFiltersAndReplayRequest(future2, ChannelClosedException.INSTANCE, channel)) {
                        Channels.silentlyCloseChannel(channel);
                    }
                    return;
                }
                if (StackTraceInspector.recoverOnReadOrWriteException(cause)) {
                    this.logger.debug("Trying to recover from dead Channel: {}", (Object)channel);
                    future2.pendingException = cause;
                    return;
                }
            } else if (attribute2 instanceof OnLastHttpContentCallback) {
                future2 = ((OnLastHttpContentCallback)OnLastHttpContentCallback.class.cast(attribute2)).future();
            }
        }
        catch (Throwable t) {
            cause = t;
        }
        if (future2 != null) {
            try {
                this.logger.debug("Was unable to recover Future: {}", (Object)future2);
                this.requestSender.abort(channel, future2, cause);
                this.handleException(future2, e);
            }
            catch (Throwable t) {
                this.logger.error(t.getMessage(), t);
            }
        }
        this.channelManager.closeChannel(channel);
        Channels.silentlyCloseChannel(channel);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (!this.isHandledByReactiveStreams(ctx)) {
            ctx.read();
        } else {
            ctx.fireChannelReadComplete();
        }
    }

    private boolean isHandledByReactiveStreams(ChannelHandlerContext ctx) {
        return Channels.getAttribute(ctx.channel()) instanceof StreamedResponsePublisher;
    }

    void finishUpdate(NettyResponseFuture<?> future2, Channel channel, boolean close2) {
        future2.cancelTimeouts();
        if (close2) {
            this.channelManager.closeChannel(channel);
        } else {
            this.channelManager.tryToOfferChannelToPool(channel, future2.getAsyncHandler(), true, future2.getPartitionKey());
        }
        try {
            future2.done();
        }
        catch (Exception t) {
            this.logger.debug(t.getMessage(), t);
        }
    }

    public abstract void handleRead(Channel var1, NettyResponseFuture<?> var2, Object var3) throws Exception;

    public abstract void handleException(NettyResponseFuture<?> var1, Throwable var2);

    public abstract void handleChannelInactive(NettyResponseFuture<?> var1);
}

