/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.future;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;

public class StackTraceInspector {
    private static boolean exceptionInMethod(Throwable t, String className, String methodName) {
        try {
            for (StackTraceElement element2 : t.getStackTrace()) {
                if (!element2.getClassName().equals(className) || !element2.getMethodName().equals(methodName)) continue;
                return true;
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        return false;
    }

    private static boolean recoverOnConnectCloseException(Throwable t) {
        return StackTraceInspector.exceptionInMethod(t, "sun.nio.ch.SocketChannelImpl", "checkConnect") || t.getCause() != null && StackTraceInspector.recoverOnConnectCloseException(t.getCause());
    }

    public static boolean recoverOnNettyDisconnectException(Throwable t) {
        return t instanceof ClosedChannelException || StackTraceInspector.exceptionInMethod(t, "play.shaded.ahc.io.netty.handler.ssl.SslHandler", "disconnect") || t.getCause() != null && StackTraceInspector.recoverOnConnectCloseException(t.getCause());
    }

    public static boolean recoverOnReadOrWriteException(Throwable t) {
        if (t instanceof IOException && "Connection reset by peer".equalsIgnoreCase(t.getMessage())) {
            return true;
        }
        try {
            for (StackTraceElement element2 : t.getStackTrace()) {
                String className = element2.getClassName();
                String methodName = element2.getMethodName();
                if (!className.equals("sun.nio.ch.SocketDispatcher") || !methodName.equals("read") && !methodName.equals("write")) continue;
                return true;
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        return t.getCause() != null && StackTraceInspector.recoverOnReadOrWriteException(t.getCause());
    }
}

