/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.channel;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import play.shaded.ahc.org.asynchttpclient.exception.TooManyConnectionsPerHostException;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ConnectionSemaphore;
import play.shaded.ahc.org.asynchttpclient.netty.channel.NonBlockingSemaphore;
import play.shaded.ahc.org.asynchttpclient.netty.channel.NonBlockingSemaphoreInfinite;
import play.shaded.ahc.org.asynchttpclient.netty.channel.NonBlockingSemaphoreLike;
import play.shaded.ahc.org.asynchttpclient.util.ThrowableUtil;

public class PerHostConnectionSemaphore
implements ConnectionSemaphore {
    private final ConnectionSemaphore globalSemaphore;
    private final ConcurrentHashMap<Object, NonBlockingSemaphore> freeChannelsPerHost = new ConcurrentHashMap();
    private final int maxConnectionsPerHost;
    private final IOException tooManyConnectionsPerHost;

    PerHostConnectionSemaphore(int maxConnectionsPerHost, ConnectionSemaphore globalSemaphore) {
        this.globalSemaphore = globalSemaphore;
        this.tooManyConnectionsPerHost = ThrowableUtil.unknownStackTrace(new TooManyConnectionsPerHostException(maxConnectionsPerHost), PerHostConnectionSemaphore.class, "acquireChannelLock");
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    @Override
    public void acquireChannelLock(Object partitionKey) throws IOException {
        this.globalSemaphore.acquireChannelLock(partitionKey);
        if (!this.getFreeConnectionsForHost(partitionKey).tryAcquire()) {
            this.globalSemaphore.releaseChannelLock(partitionKey);
            throw this.tooManyConnectionsPerHost;
        }
    }

    @Override
    public void releaseChannelLock(Object partitionKey) {
        this.globalSemaphore.releaseChannelLock(partitionKey);
        this.getFreeConnectionsForHost(partitionKey).release();
    }

    private NonBlockingSemaphoreLike getFreeConnectionsForHost(Object partitionKey) {
        return this.maxConnectionsPerHost > 0 ? (NonBlockingSemaphoreLike)this.freeChannelsPerHost.computeIfAbsent(partitionKey, pk -> new NonBlockingSemaphore(this.maxConnectionsPerHost)) : NonBlockingSemaphoreInfinite.INSTANCE;
    }
}

