/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.channel;

import java.io.IOException;
import play.shaded.ahc.org.asynchttpclient.exception.TooManyConnectionsException;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ConnectionSemaphore;
import play.shaded.ahc.org.asynchttpclient.netty.channel.NonBlockingSemaphore;
import play.shaded.ahc.org.asynchttpclient.netty.channel.NonBlockingSemaphoreInfinite;
import play.shaded.ahc.org.asynchttpclient.netty.channel.NonBlockingSemaphoreLike;
import play.shaded.ahc.org.asynchttpclient.util.ThrowableUtil;

public class MaxConnectionSemaphore
implements ConnectionSemaphore {
    private final NonBlockingSemaphoreLike freeChannels;
    private final IOException tooManyConnections;

    MaxConnectionSemaphore(int maxConnections) {
        this.tooManyConnections = ThrowableUtil.unknownStackTrace(new TooManyConnectionsException(maxConnections), MaxConnectionSemaphore.class, "acquireChannelLock");
        this.freeChannels = maxConnections > 0 ? new NonBlockingSemaphore(maxConnections) : NonBlockingSemaphoreInfinite.INSTANCE;
    }

    @Override
    public void acquireChannelLock(Object partitionKey) throws IOException {
        if (!this.freeChannels.tryAcquire()) {
            throw this.tooManyConnections;
        }
    }

    @Override
    public void releaseChannelLock(Object partitionKey) {
        this.freeChannels.release();
    }
}

