/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.channel;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.shaded.ahc.io.netty.bootstrap.Bootstrap;
import play.shaded.ahc.io.netty.buffer.ByteBufAllocator;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelFactory;
import play.shaded.ahc.io.netty.channel.ChannelHandler;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.channel.ChannelInitializer;
import play.shaded.ahc.io.netty.channel.ChannelOption;
import play.shaded.ahc.io.netty.channel.ChannelPipeline;
import play.shaded.ahc.io.netty.channel.EventLoopGroup;
import play.shaded.ahc.io.netty.channel.group.ChannelGroup;
import play.shaded.ahc.io.netty.channel.group.DefaultChannelGroup;
import play.shaded.ahc.io.netty.channel.nio.NioEventLoopGroup;
import play.shaded.ahc.io.netty.channel.oio.OioEventLoopGroup;
import play.shaded.ahc.io.netty.channel.socket.nio.NioSocketChannel;
import play.shaded.ahc.io.netty.handler.codec.http.HttpClientCodec;
import play.shaded.ahc.io.netty.handler.codec.http.HttpContentDecompressor;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import play.shaded.ahc.io.netty.handler.logging.LogLevel;
import play.shaded.ahc.io.netty.handler.logging.LoggingHandler;
import play.shaded.ahc.io.netty.handler.proxy.ProxyHandler;
import play.shaded.ahc.io.netty.handler.proxy.Socks4ProxyHandler;
import play.shaded.ahc.io.netty.handler.proxy.Socks5ProxyHandler;
import play.shaded.ahc.io.netty.handler.ssl.SslHandler;
import play.shaded.ahc.io.netty.handler.stream.ChunkedWriteHandler;
import play.shaded.ahc.io.netty.resolver.NameResolver;
import play.shaded.ahc.io.netty.util.Timer;
import play.shaded.ahc.io.netty.util.concurrent.DefaultThreadFactory;
import play.shaded.ahc.io.netty.util.concurrent.Future;
import play.shaded.ahc.io.netty.util.concurrent.GlobalEventExecutor;
import play.shaded.ahc.io.netty.util.concurrent.ImmediateEventExecutor;
import play.shaded.ahc.io.netty.util.concurrent.Promise;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.ClientStats;
import play.shaded.ahc.org.asynchttpclient.HostStats;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.SslEngineFactory;
import play.shaded.ahc.org.asynchttpclient.channel.ChannelPool;
import play.shaded.ahc.org.asynchttpclient.channel.ChannelPoolPartitioning;
import play.shaded.ahc.org.asynchttpclient.channel.NoopChannelPool;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.OnLastHttpContentCallback;
import play.shaded.ahc.org.asynchttpclient.netty.channel.Channels;
import play.shaded.ahc.org.asynchttpclient.netty.channel.DefaultChannelPool;
import play.shaded.ahc.org.asynchttpclient.netty.channel.NioSocketChannelFactory;
import play.shaded.ahc.org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import play.shaded.ahc.org.asynchttpclient.netty.handler.HttpHandler;
import play.shaded.ahc.org.asynchttpclient.netty.handler.WebSocketHandler;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import play.shaded.ahc.org.asynchttpclient.netty.ssl.DefaultSslEngineFactory;
import play.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;

public class ChannelManager {
    public static final String HTTP_CLIENT_CODEC = "http";
    public static final String SSL_HANDLER = "ssl";
    public static final String SOCKS_HANDLER = "socks";
    public static final String INFLATER_HANDLER = "inflater";
    public static final String CHUNKED_WRITER_HANDLER = "chunked-writer";
    public static final String WS_DECODER_HANDLER = "ws-decoder";
    public static final String WS_FRAME_AGGREGATOR = "ws-aggregator";
    public static final String WS_COMPRESSOR_HANDLER = "ws-compressor";
    public static final String WS_ENCODER_HANDLER = "ws-encoder";
    public static final String AHC_HTTP_HANDLER = "ahc-http";
    public static final String AHC_WS_HANDLER = "ahc-ws";
    public static final String LOGGING_HANDLER = "logging";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    private final AsyncHttpClientConfig config;
    private final SslEngineFactory sslEngineFactory;
    private final EventLoopGroup eventLoopGroup;
    private final boolean allowReleaseEventLoopGroup;
    private final Bootstrap httpBootstrap;
    private final Bootstrap wsBootstrap;
    private final long handshakeTimeout;
    private final ChannelPool channelPool;
    private final ChannelGroup openChannels;
    private AsyncHttpClientHandler wsHandler;

    public ChannelManager(AsyncHttpClientConfig config, Timer nettyTimer) {
        ChannelFactory<NioSocketChannel> channelFactory;
        this.config = config;
        this.sslEngineFactory = config.getSslEngineFactory() != null ? config.getSslEngineFactory() : new DefaultSslEngineFactory();
        try {
            this.sslEngineFactory.init(config);
        }
        catch (SSLException e) {
            throw new RuntimeException("Could not initialize sslEngineFactory", e);
        }
        ChannelPool channelPool = config.getChannelPool();
        if (channelPool == null) {
            channelPool = config.isKeepAlive() ? new DefaultChannelPool(config, nettyTimer) : NoopChannelPool.INSTANCE;
        }
        this.channelPool = channelPool;
        this.openChannels = new DefaultChannelGroup("asyncHttpClient", GlobalEventExecutor.INSTANCE);
        this.handshakeTimeout = config.getHandshakeTimeout();
        ThreadFactory threadFactory = config.getThreadFactory() != null ? config.getThreadFactory() : new DefaultThreadFactory(config.getThreadPoolName());
        boolean bl = this.allowReleaseEventLoopGroup = config.getEventLoopGroup() == null;
        if (this.allowReleaseEventLoopGroup) {
            if (config.isUseNativeTransport()) {
                this.eventLoopGroup = this.newEpollEventLoopGroup(config.getIoThreadsCount(), threadFactory);
                channelFactory = this.getEpollSocketChannelFactory();
            } else {
                this.eventLoopGroup = new NioEventLoopGroup(config.getIoThreadsCount(), threadFactory);
                channelFactory = NioSocketChannelFactory.INSTANCE;
            }
        } else {
            this.eventLoopGroup = config.getEventLoopGroup();
            if (this.eventLoopGroup instanceof OioEventLoopGroup) {
                throw new IllegalArgumentException("Oio is not supported");
            }
            channelFactory = this.eventLoopGroup instanceof NioEventLoopGroup ? NioSocketChannelFactory.INSTANCE : this.getEpollSocketChannelFactory();
        }
        this.httpBootstrap = this.newBootstrap(channelFactory, this.eventLoopGroup, config);
        this.wsBootstrap = this.newBootstrap(channelFactory, this.eventLoopGroup, config);
        this.httpBootstrap.option(ChannelOption.AUTO_READ, false);
    }

    public static boolean isSslHandlerConfigured(ChannelPipeline pipeline) {
        return pipeline.get(SSL_HANDLER) != null;
    }

    private Bootstrap newBootstrap(ChannelFactory<? extends Channel> channelFactory, EventLoopGroup eventLoopGroup, AsyncHttpClientConfig config) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(channelFactory)).group(eventLoopGroup)).option(ChannelOption.ALLOCATOR, config.getAllocator() != null ? config.getAllocator() : ByteBufAllocator.DEFAULT)).option(ChannelOption.TCP_NODELAY, config.isTcpNoDelay())).option(ChannelOption.SO_REUSEADDR, config.isSoReuseAddress())).option(ChannelOption.AUTO_CLOSE, false);
        if (config.getConnectTimeout() > 0) {
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, config.getConnectTimeout());
        }
        if (config.getSoLinger() >= 0) {
            bootstrap.option(ChannelOption.SO_LINGER, config.getSoLinger());
        }
        if (config.getSoSndBuf() >= 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, config.getSoSndBuf());
        }
        if (config.getSoRcvBuf() >= 0) {
            bootstrap.option(ChannelOption.SO_RCVBUF, config.getSoRcvBuf());
        }
        for (Map.Entry<ChannelOption<Object>, Object> entry2 : config.getChannelOptions().entrySet()) {
            bootstrap.option(entry2.getKey(), entry2.getValue());
        }
        return bootstrap;
    }

    private EventLoopGroup newEpollEventLoopGroup(int ioThreadsCount, ThreadFactory threadFactory) {
        try {
            Class<?> epollEventLoopGroupClass = Class.forName("play.shaded.ahc.io.netty.channel.epoll.EpollEventLoopGroup");
            return (EventLoopGroup)epollEventLoopGroupClass.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(ioThreadsCount, threadFactory);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ChannelFactory<? extends Channel> getEpollSocketChannelFactory() {
        try {
            return (ChannelFactory)Class.forName("play.shaded.ahc.org.asynchttpclient.netty.channel.EpollSocketChannelFactory").newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void configureBootstraps(NettyRequestSender requestSender) {
        final HttpHandler httpHandler = new HttpHandler(this.config, this, requestSender);
        this.wsHandler = new WebSocketHandler(this.config, this, requestSender);
        final LoggingHandler loggingHandler = new LoggingHandler(LogLevel.TRACE);
        this.httpBootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline().addLast(ChannelManager.HTTP_CLIENT_CODEC, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.INFLATER_HANDLER, (ChannelHandler)ChannelManager.this.newHttpContentDecompressor()).addLast(ChannelManager.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler()).addLast(ChannelManager.AHC_HTTP_HANDLER, (ChannelHandler)httpHandler);
                if (LOGGER.isTraceEnabled()) {
                    pipeline.addFirst(ChannelManager.LOGGING_HANDLER, (ChannelHandler)loggingHandler);
                }
                if (ChannelManager.this.config.getHttpAdditionalChannelInitializer() != null) {
                    ChannelManager.this.config.getHttpAdditionalChannelInitializer().accept(ch);
                }
            }
        });
        this.wsBootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline().addLast(ChannelManager.HTTP_CLIENT_CODEC, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.AHC_WS_HANDLER, (ChannelHandler)ChannelManager.this.wsHandler);
                if (ChannelManager.this.config.isEnableWebSocketCompression()) {
                    pipeline.addBefore(ChannelManager.AHC_WS_HANDLER, ChannelManager.WS_COMPRESSOR_HANDLER, WebSocketClientCompressionHandler.INSTANCE);
                }
                if (LOGGER.isDebugEnabled()) {
                    pipeline.addFirst(ChannelManager.LOGGING_HANDLER, (ChannelHandler)loggingHandler);
                }
                if (ChannelManager.this.config.getWsAdditionalChannelInitializer() != null) {
                    ChannelManager.this.config.getWsAdditionalChannelInitializer().accept(ch);
                }
            }
        });
    }

    private HttpContentDecompressor newHttpContentDecompressor() {
        if (this.config.isKeepEncodingHeader()) {
            return new HttpContentDecompressor(){

                @Override
                protected String getTargetContentEncoding(String contentEncoding) {
                    return contentEncoding;
                }
            };
        }
        return new HttpContentDecompressor();
    }

    public final void tryToOfferChannelToPool(Channel channel, AsyncHandler<?> asyncHandler, boolean keepAlive2, Object partitionKey) {
        if (channel.isActive() && keepAlive2) {
            LOGGER.debug("Adding key: {} for channel {}", partitionKey, (Object)channel);
            Channels.setDiscard(channel);
            try {
                asyncHandler.onConnectionOffer(channel);
            }
            catch (Exception e) {
                LOGGER.error("onConnectionOffer crashed", e);
            }
            if (!this.channelPool.offer(channel, partitionKey)) {
                this.closeChannel(channel);
            }
        } else {
            this.closeChannel(channel);
        }
    }

    public Channel poll(Uri uri, String virtualHost, ProxyServer proxy, ChannelPoolPartitioning connectionPoolPartitioning) {
        Object partitionKey = connectionPoolPartitioning.getPartitionKey(uri, virtualHost, proxy);
        return this.channelPool.poll(partitionKey);
    }

    public void removeAll(Channel connection) {
        this.channelPool.removeAll(connection);
    }

    private void doClose() {
        this.openChannels.close();
        this.channelPool.destroy();
    }

    public void close() {
        if (this.allowReleaseEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully(this.config.getShutdownQuietPeriod(), this.config.getShutdownTimeout(), TimeUnit.MILLISECONDS).addListener(future2 -> this.doClose());
        } else {
            this.doClose();
        }
    }

    public void closeChannel(Channel channel) {
        LOGGER.debug("Closing Channel {} ", (Object)channel);
        Channels.setDiscard(channel);
        this.removeAll(channel);
        Channels.silentlyCloseChannel(channel);
    }

    public void registerOpenChannel(Channel channel) {
        this.openChannels.add(channel);
    }

    private HttpClientCodec newHttpClientCodec() {
        return new HttpClientCodec(this.config.getHttpClientCodecMaxInitialLineLength(), this.config.getHttpClientCodecMaxHeaderSize(), this.config.getHttpClientCodecMaxChunkSize(), false, this.config.isValidateResponseHeaders(), this.config.getHttpClientCodecInitialBufferSize());
    }

    private SslHandler createSslHandler(String peerHost, int peerPort) {
        SSLEngine sslEngine = this.sslEngineFactory.newSslEngine(this.config, peerHost, peerPort);
        SslHandler sslHandler = new SslHandler(sslEngine);
        if (this.handshakeTimeout > 0L) {
            sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeout);
        }
        return sslHandler;
    }

    public Future<Channel> updatePipelineForHttpTunneling(ChannelPipeline pipeline, Uri requestUri) {
        Future<Channel> whenHanshaked = null;
        if (pipeline.get(HTTP_CLIENT_CODEC) != null) {
            pipeline.remove(HTTP_CLIENT_CODEC);
        }
        if (requestUri.isSecured()) {
            if (!ChannelManager.isSslHandlerConfigured(pipeline)) {
                SslHandler sslHandler = this.createSslHandler(requestUri.getHost(), requestUri.getExplicitPort());
                whenHanshaked = sslHandler.handshakeFuture();
                pipeline.addBefore(INFLATER_HANDLER, SSL_HANDLER, sslHandler);
            }
            pipeline.addAfter(SSL_HANDLER, HTTP_CLIENT_CODEC, this.newHttpClientCodec());
        } else {
            pipeline.addBefore(AHC_HTTP_HANDLER, HTTP_CLIENT_CODEC, this.newHttpClientCodec());
        }
        if (requestUri.isWebSocket()) {
            pipeline.addAfter(AHC_HTTP_HANDLER, AHC_WS_HANDLER, this.wsHandler);
            pipeline.remove(AHC_HTTP_HANDLER);
        }
        return whenHanshaked;
    }

    public SslHandler addSslHandler(ChannelPipeline pipeline, Uri uri, String virtualHost, boolean hasSocksProxyHandler) {
        int peerPort;
        String peerHost;
        if (virtualHost != null) {
            int i = virtualHost.indexOf(58);
            if (i == -1) {
                peerHost = virtualHost;
                peerPort = uri.getSchemeDefaultPort();
            } else {
                peerHost = virtualHost.substring(0, i);
                peerPort = Integer.valueOf(virtualHost.substring(i + 1));
            }
        } else {
            peerHost = uri.getHost();
            peerPort = uri.getExplicitPort();
        }
        SslHandler sslHandler = this.createSslHandler(peerHost, peerPort);
        if (hasSocksProxyHandler) {
            pipeline.addAfter(SOCKS_HANDLER, SSL_HANDLER, sslHandler);
        } else {
            pipeline.addFirst(SSL_HANDLER, (ChannelHandler)sslHandler);
        }
        return sslHandler;
    }

    public Future<Bootstrap> getBootstrap(Uri uri, NameResolver<InetAddress> nameResolver, final ProxyServer proxy) {
        Promise<Bootstrap> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        if (uri.isWebSocket() && proxy == null) {
            return promise.setSuccess(this.wsBootstrap);
        }
        if (proxy != null && proxy.getProxyType().isSocks()) {
            Bootstrap socksBootstrap = this.httpBootstrap.clone();
            final ChannelHandler httpBootstrapHandler = socksBootstrap.config().handler();
            nameResolver.resolve(proxy.getHost()).addListener(whenProxyAddress -> {
                if (whenProxyAddress.isSuccess()) {
                    socksBootstrap.handler(new ChannelInitializer<Channel>(){

                        @Override
                        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                            httpBootstrapHandler.handlerAdded(ctx);
                            super.handlerAdded(ctx);
                        }

                        @Override
                        protected void initChannel(Channel channel) throws Exception {
                            ProxyHandler socksProxyHandler;
                            InetSocketAddress proxyAddress = new InetSocketAddress((InetAddress)whenProxyAddress.get(), proxy.getPort());
                            Realm realm = proxy.getRealm();
                            String username = realm != null ? realm.getPrincipal() : null;
                            String password = realm != null ? realm.getPassword() : null;
                            switch (proxy.getProxyType()) {
                                case SOCKS_V4: {
                                    socksProxyHandler = new Socks4ProxyHandler(proxyAddress, username);
                                    break;
                                }
                                case SOCKS_V5: {
                                    socksProxyHandler = new Socks5ProxyHandler(proxyAddress, username, password);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Only SOCKS4 and SOCKS5 supported at the moment.");
                                }
                            }
                            channel.pipeline().addFirst(ChannelManager.SOCKS_HANDLER, (ChannelHandler)socksProxyHandler);
                        }
                    });
                    promise.setSuccess(socksBootstrap);
                } else {
                    promise.setFailure(whenProxyAddress.cause());
                }
            });
        } else {
            promise.setSuccess(this.httpBootstrap);
        }
        return promise;
    }

    public void upgradePipelineForWebSockets(ChannelPipeline pipeline) {
        pipeline.addAfter(HTTP_CLIENT_CODEC, WS_ENCODER_HANDLER, new WebSocket08FrameEncoder(true));
        pipeline.addAfter(WS_ENCODER_HANDLER, WS_DECODER_HANDLER, new WebSocket08FrameDecoder(false, this.config.isEnableWebSocketCompression(), this.config.getWebSocketMaxFrameSize()));
        if (this.config.isAggregateWebSocketFrameFragments()) {
            pipeline.addAfter(WS_DECODER_HANDLER, WS_FRAME_AGGREGATOR, new WebSocketFrameAggregator(this.config.getWebSocketMaxBufferSize()));
        }
        pipeline.remove(HTTP_CLIENT_CODEC);
    }

    private OnLastHttpContentCallback newDrainCallback(NettyResponseFuture<?> future2, final Channel channel, final boolean keepAlive2, final Object partitionKey) {
        return new OnLastHttpContentCallback(future2){

            @Override
            public void call() {
                ChannelManager.this.tryToOfferChannelToPool(channel, this.future.getAsyncHandler(), keepAlive2, partitionKey);
            }
        };
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future2) {
        this.drainChannelAndOffer(channel, future2, future2.isKeepAlive(), future2.getPartitionKey());
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future2, boolean keepAlive2, Object partitionKey) {
        Channels.setAttribute(channel, this.newDrainCallback(future2, channel, keepAlive2, partitionKey));
    }

    public ChannelPool getChannelPool() {
        return this.channelPool;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public ClientStats getClientStats() {
        Map totalConnectionsPerHost = this.openChannels.stream().map(Channel::remoteAddress).filter(a2 -> a2.getClass() == InetSocketAddress.class).map(a2 -> (InetSocketAddress)a2).map(InetSocketAddress::getHostName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map<String, Long> idleConnectionsPerHost = this.channelPool.getIdleChannelCountPerHost();
        Map<String, HostStats> statsPerHost = totalConnectionsPerHost.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry2 -> {
            long totalConnectionCount = (Long)entry2.getValue();
            long idleConnectionCount = idleConnectionsPerHost.getOrDefault(entry2.getKey(), 0L);
            long activeConnectionCount = totalConnectionCount - idleConnectionCount;
            return new HostStats(activeConnectionCount, idleConnectionCount);
        }));
        return new ClientStats(statsPerHost);
    }

    public boolean isOpen() {
        return this.channelPool.isOpen();
    }
}

