/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.handler.resumable;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.shaded.ahc.org.asynchttpclient.handler.resumable.ResumableAsyncHandler;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;

public class PropertiesBasedResumableProcessor
implements ResumableAsyncHandler.ResumableProcessor {
    private static final Logger log = LoggerFactory.getLogger(PropertiesBasedResumableProcessor.class);
    private static final File TMP = new File(System.getProperty("java.io.tmpdir"), "ahc");
    private static final String storeName = "ResumableAsyncHandler.properties";
    private final ConcurrentHashMap<String, Long> properties = new ConcurrentHashMap();

    private static String append(Map.Entry<String, Long> e) {
        return e.getKey() + '=' + e.getValue() + '\n';
    }

    @Override
    public void put(String url, long transferredBytes) {
        this.properties.put(url, transferredBytes);
    }

    @Override
    public void remove(String uri) {
        if (uri != null) {
            this.properties.remove(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Map<String, Long> map2) {
        log.debug("Saving current download state {}", (Object)this.properties.toString());
        OutputStream os = null;
        try {
            if (!TMP.exists() && !TMP.mkdirs()) {
                throw new IllegalStateException("Unable to create directory: " + TMP.getAbsolutePath());
            }
            File f2 = new File(TMP, storeName);
            if (!f2.exists() && !f2.createNewFile()) {
                throw new IllegalStateException("Unable to create temp file: " + f2.getAbsolutePath());
            }
            if (!f2.canWrite()) {
                throw new IllegalStateException();
            }
            os = Files.newOutputStream(f2.toPath(), new OpenOption[0]);
            for (Map.Entry<String, Long> e : this.properties.entrySet()) {
                os.write(PropertiesBasedResumableProcessor.append(e).getBytes(StandardCharsets.UTF_8));
            }
            os.flush();
        }
        catch (Throwable e) {
            try {
                log.warn(e.getMessage(), e);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                MiscUtils.closeSilently(os);
            }
        }
        MiscUtils.closeSilently(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> load() {
        try (Scanner scan2 = null;){
            scan2 = new Scanner(new File(TMP, storeName), StandardCharsets.UTF_8.name());
            scan2.useDelimiter("[=\n]");
            while (scan2.hasNext()) {
                String key = scan2.next().trim();
                String value2 = scan2.next().trim();
                this.properties.put(key, Long.valueOf(value2));
            }
            log.debug("Loading previous download state {}", (Object)this.properties.toString());
        }
        return this.properties;
    }
}

