/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.filter;

import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Semaphore;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;

public class ReleasePermitOnComplete {
    public static <T> AsyncHandler<T> wrap(AsyncHandler<T> handler, Semaphore available) {
        Class<?> handlerClass = handler.getClass();
        ClassLoader classLoader = handlerClass.getClassLoader();
        Class<?>[] interfaces2 = ReleasePermitOnComplete.allInterfaces(handlerClass);
        return (AsyncHandler)Proxy.newProxyInstance(classLoader, interfaces2, (proxy, method2, args2) -> {
            try {
                Object object = method2.invoke((Object)handler, args2);
                return object;
            }
            finally {
                switch (method2.getName()) {
                    case "onCompleted": 
                    case "onThrowable": {
                        available.release();
                    }
                }
            }
        });
    }

    private static Class<?>[] allInterfaces(Class<?> handlerClass) {
        HashSet allInterfaces = new HashSet();
        for (Class<?> clazz2 = handlerClass; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Collections.addAll(allInterfaces, clazz2.getInterfaces());
        }
        return allInterfaces.toArray(new Class[allInterfaces.size()]);
    }
}

