/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.cookie;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.org.asynchttpclient.cookie.CookieStore;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import play.shaded.ahc.org.asynchttpclient.util.Assertions;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;

public final class ThreadSafeCookieStore
implements CookieStore {
    private Map<CookieKey, StoredCookie> cookieJar = new ConcurrentHashMap<CookieKey, StoredCookie>();

    @Override
    public void add(Uri uri, Cookie cookie2) {
        String thisRequestDomain = this.requestDomain(uri);
        String thisRequestPath = this.requestPath(uri);
        this.add(thisRequestDomain, thisRequestPath, cookie2);
    }

    @Override
    public List<Cookie> get(Uri uri) {
        return this.get(this.requestDomain(uri), this.requestPath(uri), uri.isSecured());
    }

    @Override
    public List<Cookie> getAll() {
        boolean[] removeExpired = new boolean[]{false};
        List<Cookie> result2 = this.cookieJar.entrySet().stream().filter(pair2 -> {
            boolean hasCookieExpired = this.hasCookieExpired(((StoredCookie)pair2.getValue()).cookie, ((StoredCookie)pair2.getValue()).createdAt);
            if (hasCookieExpired && !removeExpired[0]) {
                removeExpired[0] = true;
            }
            return !hasCookieExpired;
        }).map(pair2 -> ((StoredCookie)pair2.getValue()).cookie).collect(Collectors.toList());
        if (removeExpired[0]) {
            this.removeExpired();
        }
        return result2;
    }

    @Override
    public boolean remove(Predicate<Cookie> predicate) {
        return this.cookieJar.entrySet().removeIf(v -> predicate.test(((StoredCookie)v.getValue()).cookie));
    }

    @Override
    public boolean clear() {
        boolean result2 = !this.cookieJar.isEmpty();
        this.cookieJar.clear();
        return result2;
    }

    private String requestDomain(Uri requestUri) {
        return requestUri.getHost().toLowerCase();
    }

    private String requestPath(Uri requestUri) {
        return requestUri.getPath().isEmpty() ? "/" : requestUri.getPath();
    }

    private AbstractMap.SimpleEntry<String, Boolean> cookieDomain(String cookieDomain, String requestDomain) {
        if (cookieDomain != null) {
            String normalizedCookieDomain = cookieDomain.toLowerCase();
            return new AbstractMap.SimpleEntry<String, Boolean>(!cookieDomain.isEmpty() && cookieDomain.charAt(0) == '.' ? normalizedCookieDomain.substring(1) : normalizedCookieDomain, false);
        }
        return new AbstractMap.SimpleEntry<String, Boolean>(requestDomain, true);
    }

    private String cookiePath(String rawCookiePath, String requestPath) {
        if (MiscUtils.isNonEmpty(rawCookiePath) && rawCookiePath.charAt(0) == '/') {
            return rawCookiePath;
        }
        int indexOfLastSlash = requestPath.lastIndexOf(47);
        if (!requestPath.isEmpty() && requestPath.charAt(0) == '/' && indexOfLastSlash > 0) {
            return requestPath.substring(0, indexOfLastSlash);
        }
        return "/";
    }

    private boolean hasCookieExpired(Cookie cookie2, long whenCreated) {
        if (cookie2.maxAge() == Long.MIN_VALUE) {
            return false;
        }
        if (cookie2.maxAge() <= 0L) {
            return true;
        }
        if (whenCreated > 0L) {
            long deltaSecond = (System.currentTimeMillis() - whenCreated) / 1000L;
            return deltaSecond > cookie2.maxAge();
        }
        return false;
    }

    private boolean domainsMatch(String cookieDomain, String requestDomain, boolean hostOnly) {
        return hostOnly && Objects.equals(requestDomain, cookieDomain) || Objects.equals(requestDomain, cookieDomain) || requestDomain.endsWith("." + cookieDomain);
    }

    private boolean pathsMatch(String cookiePath, String requestPath) {
        return Objects.equals(cookiePath, requestPath) || requestPath.startsWith(cookiePath) && (cookiePath.charAt(cookiePath.length() - 1) == '/' || requestPath.charAt(cookiePath.length()) == '/');
    }

    private void add(String requestDomain, String requestPath, Cookie cookie2) {
        AbstractMap.SimpleEntry<String, Boolean> pair2 = this.cookieDomain(cookie2.domain(), requestDomain);
        String keyDomain = pair2.getKey();
        boolean hostOnly = pair2.getValue();
        String keyPath = this.cookiePath(cookie2.path(), requestPath);
        CookieKey key = new CookieKey(cookie2.name().toLowerCase(), keyDomain, keyPath);
        if (this.hasCookieExpired(cookie2, 0L)) {
            this.cookieJar.remove(key);
        } else {
            this.cookieJar.put(key, new StoredCookie(cookie2, hostOnly, cookie2.maxAge() != Long.MIN_VALUE));
        }
    }

    private List<Cookie> get(String domain, String path2, boolean secure2) {
        boolean[] removeExpired = new boolean[]{false};
        List<Cookie> result2 = this.cookieJar.entrySet().stream().filter(pair2 -> {
            CookieKey key = (CookieKey)pair2.getKey();
            StoredCookie storedCookie = (StoredCookie)pair2.getValue();
            boolean hasCookieExpired = this.hasCookieExpired(storedCookie.cookie, storedCookie.createdAt);
            if (hasCookieExpired && !removeExpired[0]) {
                removeExpired[0] = true;
            }
            return !hasCookieExpired && this.domainsMatch(key.domain, domain, storedCookie.hostOnly) && this.pathsMatch(key.path, path2) && (secure2 || !storedCookie.cookie.isSecure());
        }).map(v -> ((StoredCookie)v.getValue()).cookie).collect(Collectors.toList());
        if (removeExpired[0]) {
            this.removeExpired();
        }
        return result2;
    }

    private void removeExpired() {
        this.cookieJar.entrySet().removeIf(v -> this.hasCookieExpired(((StoredCookie)v.getValue()).cookie, ((StoredCookie)v.getValue()).createdAt));
    }

    private static class StoredCookie {
        final Cookie cookie;
        final boolean hostOnly;
        final boolean persistent;
        final long createdAt = System.currentTimeMillis();

        StoredCookie(Cookie cookie2, boolean hostOnly, boolean persistent) {
            this.cookie = cookie2;
            this.hostOnly = hostOnly;
            this.persistent = persistent;
        }

        public String toString() {
            return String.format("%s; hostOnly %s; persistent %s", this.cookie.toString(), this.hostOnly, this.persistent);
        }
    }

    private static class CookieKey
    implements Comparable<CookieKey> {
        final String name;
        final String domain;
        final String path;

        CookieKey(String name, String domain, String path2) {
            this.name = name;
            this.domain = domain;
            this.path = path2;
        }

        @Override
        public int compareTo(CookieKey o) {
            Assertions.assertNotNull(o, "Parameter can't be null");
            int result2 = this.name.compareTo(o.name);
            if (result2 == 0 && (result2 = this.domain.compareTo(o.domain)) == 0) {
                result2 = this.path.compareTo(o.path);
            }
            return result2;
        }

        public boolean equals(Object obj) {
            return obj instanceof CookieKey && this.compareTo((CookieKey)obj) == 0;
        }

        public int hashCode() {
            int result2 = 17;
            result2 = 31 * result2 + this.name.hashCode();
            result2 = 31 * result2 + this.domain.hashCode();
            result2 = 31 * result2 + this.path.hashCode();
            return result2;
        }

        public String toString() {
            return String.format("%s: %s; %s", this.name, this.domain, this.path);
        }
    }
}

