/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.channel;

import play.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import play.shaded.ahc.org.asynchttpclient.proxy.ProxyType;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;

public interface ChannelPoolPartitioning {
    public Object getPartitionKey(Uri var1, String var2, ProxyServer var3);

    public static class CompositePartitionKey {
        private final String targetHostBaseUrl;
        private final String virtualHost;
        private final String proxyHost;
        private final int proxyPort;
        private final ProxyType proxyType;

        CompositePartitionKey(String targetHostBaseUrl, String virtualHost, String proxyHost, int proxyPort, ProxyType proxyType) {
            this.targetHostBaseUrl = targetHostBaseUrl;
            this.virtualHost = virtualHost;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyType = proxyType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositePartitionKey that2 = (CompositePartitionKey)o;
            if (this.proxyPort != that2.proxyPort) {
                return false;
            }
            if (this.targetHostBaseUrl != null ? !this.targetHostBaseUrl.equals(that2.targetHostBaseUrl) : that2.targetHostBaseUrl != null) {
                return false;
            }
            if (this.virtualHost != null ? !this.virtualHost.equals(that2.virtualHost) : that2.virtualHost != null) {
                return false;
            }
            if (this.proxyHost != null ? !this.proxyHost.equals(that2.proxyHost) : that2.proxyHost != null) {
                return false;
            }
            return this.proxyType == that2.proxyType;
        }

        public int hashCode() {
            int result2 = this.targetHostBaseUrl != null ? this.targetHostBaseUrl.hashCode() : 0;
            result2 = 31 * result2 + (this.virtualHost != null ? this.virtualHost.hashCode() : 0);
            result2 = 31 * result2 + (this.proxyHost != null ? this.proxyHost.hashCode() : 0);
            result2 = 31 * result2 + this.proxyPort;
            result2 = 31 * result2 + (this.proxyType != null ? this.proxyType.hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "CompositePartitionKey(targetHostBaseUrl=" + this.targetHostBaseUrl + ", virtualHost=" + this.virtualHost + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyType=" + (Object)((Object)this.proxyType);
        }
    }

    public static enum PerHostChannelPoolPartitioning implements ChannelPoolPartitioning
    {
        INSTANCE;


        @Override
        public Object getPartitionKey(Uri uri, String virtualHost, ProxyServer proxyServer) {
            String targetHostBaseUrl = uri.getBaseUrl();
            if (proxyServer == null) {
                if (virtualHost == null) {
                    return targetHostBaseUrl;
                }
                return new CompositePartitionKey(targetHostBaseUrl, virtualHost, null, 0, null);
            }
            return new CompositePartitionKey(targetHostBaseUrl, virtualHost, proxyServer.getHost(), uri.isSecured() && proxyServer.getProxyType() == ProxyType.HTTP ? proxyServer.getSecuredPort() : proxyServer.getPort(), proxyServer.getProxyType());
        }
    }
}

