/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient;

import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.shaded.ahc.io.netty.channel.EventLoopGroup;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.io.netty.util.HashedWheelTimer;
import play.shaded.ahc.io.netty.util.Timer;
import play.shaded.ahc.io.netty.util.concurrent.DefaultThreadFactory;
import play.shaded.ahc.org.asynchttpclient.AsyncCompletionHandlerBase;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientState;
import play.shaded.ahc.org.asynchttpclient.BoundRequestBuilder;
import play.shaded.ahc.org.asynchttpclient.ClientStats;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.ListenableFuture;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.RequestBuilder;
import play.shaded.ahc.org.asynchttpclient.Response;
import play.shaded.ahc.org.asynchttpclient.SignatureCalculator;
import play.shaded.ahc.org.asynchttpclient.channel.ChannelPool;
import play.shaded.ahc.org.asynchttpclient.filter.FilterContext;
import play.shaded.ahc.org.asynchttpclient.filter.FilterException;
import play.shaded.ahc.org.asynchttpclient.filter.RequestFilter;
import play.shaded.ahc.org.asynchttpclient.handler.resumable.ResumableAsyncHandler;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelManager;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import play.shaded.ahc.org.asynchttpclient.util.Assertions;

public class DefaultAsyncHttpClient
implements AsyncHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncHttpClient.class);
    private final AsyncHttpClientConfig config;
    private final boolean noRequestFilters;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;
    private final boolean allowStopNettyTimer;
    private final Timer nettyTimer;
    private SignatureCalculator signatureCalculator;

    public DefaultAsyncHttpClient() {
        this(new DefaultAsyncHttpClientConfig.Builder().build());
    }

    public DefaultAsyncHttpClient(AsyncHttpClientConfig config) {
        this.config = config;
        this.noRequestFilters = config.getRequestFilters().isEmpty();
        this.allowStopNettyTimer = config.getNettyTimer() == null;
        this.nettyTimer = this.allowStopNettyTimer ? this.newNettyTimer(config) : config.getNettyTimer();
        this.channelManager = new ChannelManager(config, this.nettyTimer);
        this.requestSender = new NettyRequestSender(config, this.channelManager, this.nettyTimer, new AsyncHttpClientState(this.closed));
        this.channelManager.configureBootstraps(this.requestSender);
    }

    private Timer newNettyTimer(AsyncHttpClientConfig config) {
        ThreadFactory threadFactory = config.getThreadFactory() != null ? config.getThreadFactory() : new DefaultThreadFactory(config.getThreadPoolName() + "-timer");
        HashedWheelTimer timer = new HashedWheelTimer(threadFactory);
        timer.start();
        return timer;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.channelManager.close();
            }
            catch (Throwable t) {
                LOGGER.warn("Unexpected error on ChannelManager close", t);
            }
            if (this.allowStopNettyTimer) {
                try {
                    this.nettyTimer.stop();
                }
                catch (Throwable t) {
                    LOGGER.warn("Unexpected error on HashedWheelTimer close", t);
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public DefaultAsyncHttpClient setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return this;
    }

    @Override
    public BoundRequestBuilder prepare(String method2, String url) {
        return this.requestBuilder(method2, url);
    }

    @Override
    public BoundRequestBuilder prepareGet(String url) {
        return this.requestBuilder("GET", url);
    }

    @Override
    public BoundRequestBuilder prepareConnect(String url) {
        return this.requestBuilder("CONNECT", url);
    }

    @Override
    public BoundRequestBuilder prepareOptions(String url) {
        return this.requestBuilder("OPTIONS", url);
    }

    @Override
    public BoundRequestBuilder prepareHead(String url) {
        return this.requestBuilder("HEAD", url);
    }

    @Override
    public BoundRequestBuilder preparePost(String url) {
        return this.requestBuilder("POST", url);
    }

    @Override
    public BoundRequestBuilder preparePut(String url) {
        return this.requestBuilder("PUT", url);
    }

    @Override
    public BoundRequestBuilder prepareDelete(String url) {
        return this.requestBuilder("DELETE", url);
    }

    @Override
    public BoundRequestBuilder preparePatch(String url) {
        return this.requestBuilder("PATCH", url);
    }

    @Override
    public BoundRequestBuilder prepareTrace(String url) {
        return this.requestBuilder("TRACE", url);
    }

    @Override
    public BoundRequestBuilder prepareRequest(Request request2) {
        return this.requestBuilder(request2);
    }

    @Override
    public BoundRequestBuilder prepareRequest(RequestBuilder requestBuilder) {
        return this.prepareRequest(requestBuilder.build());
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(Request request2, AsyncHandler<T> handler) {
        if (this.config.getCookieStore() != null) {
            try {
                List<Cookie> cookies2 = this.config.getCookieStore().get(request2.getUri());
                if (!cookies2.isEmpty()) {
                    RequestBuilder requestBuilder = new RequestBuilder(request2);
                    for (Cookie cookie2 : cookies2) {
                        requestBuilder.addOrReplaceCookie(cookie2);
                    }
                    request2 = requestBuilder.build();
                }
            }
            catch (Exception e) {
                handler.onThrowable(e);
                return new ListenableFuture.CompletedFailure("Failed to set cookies of request", e);
            }
        }
        if (this.noRequestFilters) {
            return this.execute(request2, handler);
        }
        FilterContext fc = new FilterContext.FilterContextBuilder<T>().asyncHandler(handler).request(request2).build();
        try {
            fc = this.preProcessRequest(fc);
        }
        catch (Exception e) {
            handler.onThrowable(e);
            return new ListenableFuture.CompletedFailure("preProcessRequest failed", e);
        }
        return this.execute(fc.getRequest(), fc.getAsyncHandler());
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(RequestBuilder requestBuilder, AsyncHandler<T> handler) {
        return this.executeRequest(requestBuilder.build(), handler);
    }

    @Override
    public ListenableFuture<Response> executeRequest(Request request2) {
        return this.executeRequest(request2, new AsyncCompletionHandlerBase());
    }

    @Override
    public ListenableFuture<Response> executeRequest(RequestBuilder requestBuilder) {
        return this.executeRequest(requestBuilder.build());
    }

    private <T> ListenableFuture<T> execute(Request request2, AsyncHandler<T> asyncHandler) {
        try {
            return this.requestSender.sendRequest(request2, asyncHandler, null);
        }
        catch (Exception e) {
            asyncHandler.onThrowable(e);
            return new ListenableFuture.CompletedFailure(e);
        }
    }

    private <T> FilterContext<T> preProcessRequest(FilterContext<T> fc) throws FilterException {
        for (RequestFilter asyncFilter : this.config.getRequestFilters()) {
            fc = asyncFilter.filter(fc);
            Assertions.assertNotNull(fc, "filterContext");
        }
        Request request2 = fc.getRequest();
        if (fc.getAsyncHandler() instanceof ResumableAsyncHandler) {
            request2 = ((ResumableAsyncHandler)ResumableAsyncHandler.class.cast(fc.getAsyncHandler())).adjustRequestRange(request2);
        }
        if (request2.getRangeOffset() != 0L) {
            RequestBuilder builder = new RequestBuilder(request2);
            builder.setHeader((CharSequence)"Range", "bytes=" + request2.getRangeOffset() + "-");
            request2 = builder.build();
        }
        fc = new FilterContext.FilterContextBuilder<T>(fc).request(request2).build();
        return fc;
    }

    public ChannelPool getChannelPool() {
        return this.channelManager.getChannelPool();
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.channelManager.getEventLoopGroup();
    }

    @Override
    public ClientStats getClientStats() {
        return this.channelManager.getClientStats();
    }

    @Override
    public void flushChannelPoolPartitions(Predicate<Object> predicate) {
        this.getChannelPool().flushPartitions(predicate);
    }

    protected BoundRequestBuilder requestBuilder(String method2, String url) {
        return (BoundRequestBuilder)((BoundRequestBuilder)new BoundRequestBuilder(this, method2, this.config.isDisableUrlEncodingForBoundRequests()).setUrl(url)).setSignatureCalculator(this.signatureCalculator);
    }

    protected BoundRequestBuilder requestBuilder(Request prototype) {
        return (BoundRequestBuilder)new BoundRequestBuilder(this, prototype).setSignatureCalculator(this.signatureCalculator);
    }

    @Override
    public AsyncHttpClientConfig getConfig() {
        return this.config;
    }
}

