/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBufAllocator;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelOption;
import play.shaded.ahc.io.netty.channel.EventLoopGroup;
import play.shaded.ahc.io.netty.handler.ssl.SslContext;
import play.shaded.ahc.io.netty.util.Timer;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.SslEngineFactory;
import play.shaded.ahc.org.asynchttpclient.channel.ChannelPool;
import play.shaded.ahc.org.asynchttpclient.channel.KeepAliveStrategy;
import play.shaded.ahc.org.asynchttpclient.cookie.CookieStore;
import play.shaded.ahc.org.asynchttpclient.filter.IOExceptionFilter;
import play.shaded.ahc.org.asynchttpclient.filter.RequestFilter;
import play.shaded.ahc.org.asynchttpclient.filter.ResponseFilter;
import play.shaded.ahc.org.asynchttpclient.netty.EagerResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.netty.LazyResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ConnectionSemaphoreFactory;
import play.shaded.ahc.org.asynchttpclient.proxy.ProxyServerSelector;

public interface AsyncHttpClientConfig {
    public String getAhcVersion();

    public String getThreadPoolName();

    public int getMaxConnections();

    public int getMaxConnectionsPerHost();

    public int getConnectTimeout();

    public int getReadTimeout();

    public int getPooledConnectionIdleTimeout();

    public int getConnectionPoolCleanerPeriod();

    public int getRequestTimeout();

    public boolean isFollowRedirect();

    public int getMaxRedirects();

    public boolean isKeepAlive();

    public String getUserAgent();

    public boolean isCompressionEnforced();

    public ThreadFactory getThreadFactory();

    public ProxyServerSelector getProxyServerSelector();

    public SslContext getSslContext();

    public Realm getRealm();

    public List<RequestFilter> getRequestFilters();

    public List<ResponseFilter> getResponseFilters();

    public List<IOExceptionFilter> getIoExceptionFilters();

    public CookieStore getCookieStore();

    public int getMaxRequestRetry();

    public boolean isDisableUrlEncodingForBoundRequests();

    public boolean isUseLaxCookieEncoder();

    public boolean isStrict302Handling();

    public int getConnectionTtl();

    public boolean isUseOpenSsl();

    public boolean isUseInsecureTrustManager();

    public boolean isDisableHttpsEndpointIdentificationAlgorithm();

    public String[] getEnabledProtocols();

    public String[] getEnabledCipherSuites();

    public boolean isFilterInsecureCipherSuites();

    public int getSslSessionCacheSize();

    public int getSslSessionTimeout();

    public int getHttpClientCodecMaxInitialLineLength();

    public int getHttpClientCodecMaxHeaderSize();

    public int getHttpClientCodecMaxChunkSize();

    public int getHttpClientCodecInitialBufferSize();

    public boolean isDisableZeroCopy();

    public int getHandshakeTimeout();

    public SslEngineFactory getSslEngineFactory();

    public int getChunkedFileChunkSize();

    public int getWebSocketMaxBufferSize();

    public int getWebSocketMaxFrameSize();

    public boolean isKeepEncodingHeader();

    public int getShutdownQuietPeriod();

    public int getShutdownTimeout();

    public Map<ChannelOption<Object>, Object> getChannelOptions();

    public EventLoopGroup getEventLoopGroup();

    public boolean isUseNativeTransport();

    public Consumer<Channel> getHttpAdditionalChannelInitializer();

    public Consumer<Channel> getWsAdditionalChannelInitializer();

    public ResponseBodyPartFactory getResponseBodyPartFactory();

    public ChannelPool getChannelPool();

    public ConnectionSemaphoreFactory getConnectionSemaphoreFactory();

    public Timer getNettyTimer();

    public KeepAliveStrategy getKeepAliveStrategy();

    public boolean isValidateResponseHeaders();

    public boolean isAggregateWebSocketFrameFragments();

    public boolean isEnableWebSocketCompression();

    public boolean isTcpNoDelay();

    public boolean isSoReuseAddress();

    public int getSoLinger();

    public int getSoSndBuf();

    public int getSoRcvBuf();

    public ByteBufAllocator getAllocator();

    public int getIoThreadsCount();

    public static enum ResponseBodyPartFactory {
        EAGER{

            @Override
            public HttpResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last2) {
                return new EagerResponseBodyPart(buf, last2);
            }
        }
        ,
        LAZY{

            @Override
            public HttpResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last2) {
                return new LazyResponseBodyPart(buf, last2);
            }
        };


        public abstract HttpResponseBodyPart newResponseBodyPart(ByteBuf var1, boolean var2);
    }
}

