/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.atomic;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.atomic.BaseMpscLinkedAtomicArrayQueueColdProducerFields;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.atomic.LinkedAtomicArrayQueueUtil;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.util.RangeUtil;

public abstract class BaseMpscLinkedAtomicArrayQueue<E>
extends BaseMpscLinkedAtomicArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();

    public BaseMpscLinkedAtomicArrayQueue(int initialCapacity) {
        AtomicReferenceArray buffer;
        RangeUtil.checkGreaterThanOrEqual(initialCapacity, 2, "initialCapacity");
        int p2capacity = Pow2.roundToPowerOfTwo(initialCapacity);
        long mask = p2capacity - 1 << 1;
        this.producerBuffer = buffer = LinkedAtomicArrayQueueUtil.allocate(p2capacity + 1);
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.soProducerLimit(mask);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after2 = this.lvConsumerIndex();
        do {
            before = after2;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after2 = this.lvConsumerIndex()));
        long size2 = currentProducerIndex - after2 >> 1;
        if (size2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size2;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e) {
        AtomicReferenceArray buffer;
        long mask;
        long pIndex;
        if (null == e) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            if (producerLimit <= pIndex) {
                int result2 = this.offerSlowPath(mask, pIndex, producerLimit);
                switch (result2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, e);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(pIndex, pIndex + 2L)) break;
        }
        int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(pIndex, mask);
        LinkedAtomicArrayQueueUtil.soElement(buffer, offset, e);
        return true;
    }

    @Override
    public E poll() {
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(index2, mask);
        Object e = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        if (e == null) {
            if (index2 != this.lvProducerIndex()) {
                while ((e = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e == JUMP) {
            AtomicReferenceArray<E> nextBuffer = this.getNextBuffer(buffer, mask);
            return this.newBufferPoll(nextBuffer, index2);
        }
        LinkedAtomicArrayQueueUtil.soElement(buffer, offset, null);
        this.soConsumerIndex(index2 + 2L);
        return e;
    }

    @Override
    public E peek() {
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(index2, mask);
        Object e = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        if (e == null && index2 != this.lvProducerIndex()) {
            while ((e = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset)) == null) {
            }
        }
        if (e == JUMP) {
            return this.newBufferPeek(this.getNextBuffer(buffer, mask), index2);
        }
        return e;
    }

    private int offerSlowPath(long mask, long pIndex, long producerLimit) {
        long cIndex = this.lvConsumerIndex();
        long bufferCapacity = this.getCurrentBufferCapacity(mask);
        int result2 = 0;
        if (cIndex + bufferCapacity > pIndex) {
            if (!this.casProducerLimit(producerLimit, cIndex + bufferCapacity)) {
                result2 = 1;
            }
        } else {
            result2 = this.availableInQueue(pIndex, cIndex) <= 0L ? 2 : (this.casProducerIndex(pIndex, pIndex + 1L) ? 3 : 1);
        }
        return result2;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private AtomicReferenceArray<E> getNextBuffer(AtomicReferenceArray<E> buffer, long mask) {
        int offset = this.nextArrayOffset(mask);
        AtomicReferenceArray nextBuffer = (AtomicReferenceArray)LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        LinkedAtomicArrayQueueUtil.soElement(buffer, offset, null);
        return nextBuffer;
    }

    private int nextArrayOffset(long mask) {
        return LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(mask + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(AtomicReferenceArray<E> nextBuffer, long index2) {
        int offset = this.newBufferAndOffset(nextBuffer, index2);
        E n = LinkedAtomicArrayQueueUtil.lvElement(nextBuffer, offset);
        if (n == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        LinkedAtomicArrayQueueUtil.soElement(nextBuffer, offset, null);
        this.soConsumerIndex(index2 + 2L);
        return n;
    }

    private E newBufferPeek(AtomicReferenceArray<E> nextBuffer, long index2) {
        int offset = this.newBufferAndOffset(nextBuffer, index2);
        E n = LinkedAtomicArrayQueueUtil.lvElement(nextBuffer, offset);
        if (null == n) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return n;
    }

    private int newBufferAndOffset(AtomicReferenceArray<E> nextBuffer, long index2) {
        this.consumerBuffer = nextBuffer;
        this.consumerMask = LinkedAtomicArrayQueueUtil.length(nextBuffer) - 2 << 1;
        int offsetInNew = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(index2, this.consumerMask);
        return offsetInNew;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(index2, mask);
        Object e = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        if (e == null) {
            return null;
        }
        if (e == JUMP) {
            AtomicReferenceArray<E> nextBuffer = this.getNextBuffer(buffer, mask);
            return this.newBufferPoll(nextBuffer, index2);
        }
        LinkedAtomicArrayQueueUtil.soElement(buffer, offset, null);
        this.soConsumerIndex(index2 + 2L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(index2, mask);
        Object e = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        if (e == JUMP) {
            return this.newBufferPeek(this.getNextBuffer(buffer, mask), index2);
        }
        return e;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2) {
        int filled;
        long result2 = 0L;
        int capacity = this.capacity();
        do {
            if ((filled = this.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)result2;
        } while ((result2 += (long)filled) <= (long)capacity);
        return (int)result2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2, int batchSize) {
        long batchIndex;
        AtomicReferenceArray buffer;
        long mask;
        long pIndex;
        block5: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            batchIndex = Math.min(producerLimit, pIndex + (long)(2 * batchSize));
            if (pIndex == producerLimit || producerLimit < batchIndex) {
                int result2 = this.offerSlowPath(mask, pIndex, producerLimit);
                switch (result2) {
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, s2.get());
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(pIndex, batchIndex)) break;
        }
        int claimedSlots = (int)((batchIndex - pIndex) / 2L);
        int i = 0;
        for (i = 0; i < claimedSlots; ++i) {
            int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(pIndex + (long)(2 * i), mask);
            LinkedAtomicArrayQueueUtil.soElement(buffer, offset, s2.get());
        }
        return claimedSlots;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s2, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        while (exit.keepRunning()) {
            while (this.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH) != 0 && exit.keepRunning()) {
            }
            int idleCounter = 0;
            while (exit.keepRunning() && this.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                idleCounter = w.idle(idleCounter);
            }
        }
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit2) {
        E m;
        int i;
        for (i = 0; i < limit2 && (m = this.relaxedPoll()) != null; ++i) {
            c.accept(m);
        }
        return i;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            E e = this.relaxedPoll();
            if (e == null) {
                idleCounter = w.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
            c.accept(e);
        }
    }

    private void resize(long oldMask, AtomicReferenceArray<E> oldBuffer, long pIndex, E e) {
        AtomicReferenceArray newBuffer;
        int newBufferLength = this.getNextBufferSize(oldBuffer);
        this.producerBuffer = newBuffer = LinkedAtomicArrayQueueUtil.allocate(newBufferLength);
        int newMask = newBufferLength - 2 << 1;
        this.producerMask = newMask;
        int offsetInOld = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(pIndex, oldMask);
        int offsetInNew = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(pIndex, newMask);
        LinkedAtomicArrayQueueUtil.soElement(newBuffer, offsetInNew, e);
        LinkedAtomicArrayQueueUtil.soElement(oldBuffer, this.nextArrayOffset(oldMask), newBuffer);
        long cIndex = this.lvConsumerIndex();
        long availableInQueue = this.availableInQueue(pIndex, cIndex);
        RangeUtil.checkPositive(availableInQueue, "availableInQueue");
        this.soProducerLimit(pIndex + Math.min((long)newMask, availableInQueue));
        this.soProducerIndex(pIndex + 2L);
        LinkedAtomicArrayQueueUtil.soElement(oldBuffer, offsetInOld, JUMP);
    }

    protected abstract int getNextBufferSize(AtomicReferenceArray<E> var1);

    protected abstract long getCurrentBufferCapacity(long var1);
}

