/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.atomic;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.util.Pow2;

abstract class AtomicReferenceArrayQueue<E>
extends AbstractQueue<E>
implements IndexedQueueSizeUtil.IndexedQueue,
QueueProgressIndicators,
MessagePassingQueue<E> {
    protected final AtomicReferenceArray<E> buffer;
    protected final int mask;

    public AtomicReferenceArrayQueue(int capacity) {
        int actualCapacity = Pow2.roundToPowerOfTwo(capacity);
        this.mask = actualCapacity - 1;
        this.buffer = new AtomicReferenceArray(actualCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    protected final int calcElementOffset(long index2, int mask) {
        return (int)index2 & mask;
    }

    protected final int calcElementOffset(long index2) {
        return (int)index2 & this.mask;
    }

    public static <E> E lvElement(AtomicReferenceArray<E> buffer, int offset) {
        return buffer.get(offset);
    }

    public static <E> E lpElement(AtomicReferenceArray<E> buffer, int offset) {
        return buffer.get(offset);
    }

    protected final E lpElement(int offset) {
        return this.buffer.get(offset);
    }

    public static <E> void spElement(AtomicReferenceArray<E> buffer, int offset, E value2) {
        buffer.lazySet(offset, value2);
    }

    protected final void spElement(int offset, E value2) {
        this.buffer.lazySet(offset, value2);
    }

    public static <E> void soElement(AtomicReferenceArray<E> buffer, int offset, E value2) {
        buffer.lazySet(offset, value2);
    }

    protected final void soElement(int offset, E value2) {
        this.buffer.lazySet(offset, value2);
    }

    public static <E> void svElement(AtomicReferenceArray<E> buffer, int offset, E value2) {
        buffer.set(offset, value2);
    }

    protected final E lvElement(int offset) {
        return AtomicReferenceArrayQueue.lvElement(this.buffer, offset);
    }

    @Override
    public final int capacity() {
        return this.mask + 1;
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this);
    }

    @Override
    public final boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public final long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public final long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }
}

