/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues;

import java.util.Iterator;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.CircularArrayOffsetCalculator;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.ConcurrentCircularArrayQueueL0Pad;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import play.shaded.ahc.io.netty.util.internal.shaded.org.jctools.util.Pow2;

public abstract class ConcurrentCircularArrayQueue<E>
extends ConcurrentCircularArrayQueueL0Pad<E> {
    protected final long mask;
    protected final E[] buffer;

    public ConcurrentCircularArrayQueue(int capacity) {
        int actualCapacity = Pow2.roundToPowerOfTwo(capacity);
        this.mask = actualCapacity - 1;
        this.buffer = CircularArrayOffsetCalculator.allocate(actualCapacity);
    }

    protected static long calcElementOffset(long index2, long mask) {
        return CircularArrayOffsetCalculator.calcElementOffset(index2, mask);
    }

    protected final long calcElementOffset(long index2) {
        return ConcurrentCircularArrayQueue.calcElementOffset(index2, this.mask);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this);
    }

    @Override
    public final boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    public int capacity() {
        return (int)(this.mask + 1L);
    }

    @Override
    public final long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public final long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }
}

