/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.util.internal;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import play.shaded.ahc.io.netty.util.internal.InternalThreadLocalMap;

public abstract class TypeParameterMatcher {
    private static final TypeParameterMatcher NOOP = new TypeParameterMatcher(){

        @Override
        public boolean match(Object msg) {
            return true;
        }
    };

    public static TypeParameterMatcher get(Class<?> parameterType) {
        Map<Class<?>, TypeParameterMatcher> getCache = InternalThreadLocalMap.get().typeParameterMatcherGetCache();
        TypeParameterMatcher matcher2 = getCache.get(parameterType);
        if (matcher2 == null) {
            matcher2 = parameterType == Object.class ? NOOP : new ReflectiveMatcher(parameterType);
            getCache.put(parameterType, matcher2);
        }
        return matcher2;
    }

    public static TypeParameterMatcher find(Object object, Class<?> parametrizedSuperclass, String typeParamName) {
        TypeParameterMatcher matcher2;
        Class<?> thisClass;
        Map<Class<?>, Map<String, TypeParameterMatcher>> findCache = InternalThreadLocalMap.get().typeParameterMatcherFindCache();
        Map<String, TypeParameterMatcher> map2 = findCache.get(thisClass = object.getClass());
        if (map2 == null) {
            map2 = new HashMap<String, TypeParameterMatcher>();
            findCache.put(thisClass, map2);
        }
        if ((matcher2 = map2.get(typeParamName)) == null) {
            matcher2 = TypeParameterMatcher.get(TypeParameterMatcher.find0(object, parametrizedSuperclass, typeParamName));
            map2.put(typeParamName, matcher2);
        }
        return matcher2;
    }

    private static Class<?> find0(Object object, Class<?> parametrizedSuperclass, String typeParamName) {
        Class<?> thisClass;
        Class<?> currentClass = thisClass = object.getClass();
        while (true) {
            if (currentClass.getSuperclass() == parametrizedSuperclass) {
                int typeParamIndex = -1;
                TypeVariable<Class<?>>[] typeParams2 = currentClass.getSuperclass().getTypeParameters();
                for (int i = 0; i < typeParams2.length; ++i) {
                    if (!typeParamName.equals(typeParams2[i].getName())) continue;
                    typeParamIndex = i;
                    break;
                }
                if (typeParamIndex < 0) {
                    throw new IllegalStateException("unknown type parameter '" + typeParamName + "': " + parametrizedSuperclass);
                }
                Type genericSuperType = currentClass.getGenericSuperclass();
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }
                Type[] actualTypeParams = ((ParameterizedType)genericSuperType).getActualTypeArguments();
                Type actualTypeParam = actualTypeParams[typeParamIndex];
                if (actualTypeParam instanceof ParameterizedType) {
                    actualTypeParam = ((ParameterizedType)actualTypeParam).getRawType();
                }
                if (actualTypeParam instanceof Class) {
                    return (Class)actualTypeParam;
                }
                if (actualTypeParam instanceof GenericArrayType) {
                    Type componentType = ((GenericArrayType)actualTypeParam).getGenericComponentType();
                    if (componentType instanceof ParameterizedType) {
                        componentType = ((ParameterizedType)componentType).getRawType();
                    }
                    if (componentType instanceof Class) {
                        return Array.newInstance((Class)componentType, 0).getClass();
                    }
                }
                if (actualTypeParam instanceof TypeVariable) {
                    TypeVariable v = (TypeVariable)actualTypeParam;
                    currentClass = thisClass;
                    if (!(v.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }
                    parametrizedSuperclass = (Class)v.getGenericDeclaration();
                    typeParamName = v.getName();
                    if (parametrizedSuperclass.isAssignableFrom(thisClass)) continue;
                    return Object.class;
                }
                return TypeParameterMatcher.fail(thisClass, typeParamName);
            }
            if ((currentClass = currentClass.getSuperclass()) == null) break;
        }
        return TypeParameterMatcher.fail(thisClass, typeParamName);
    }

    private static Class<?> fail(Class<?> type, String typeParamName) {
        throw new IllegalStateException("cannot determine the type of the type parameter '" + typeParamName + "': " + type);
    }

    public abstract boolean match(Object var1);

    TypeParameterMatcher() {
    }

    private static final class ReflectiveMatcher
    extends TypeParameterMatcher {
        private final Class<?> type;

        ReflectiveMatcher(Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean match(Object msg) {
            return this.type.isInstance(msg);
        }
    }
}

