/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.util.internal;

import play.shaded.ahc.io.netty.util.concurrent.Promise;
import play.shaded.ahc.io.netty.util.internal.ThrowableUtil;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLogger;

public final class PromiseNotificationUtil {
    private PromiseNotificationUtil() {
    }

    public static void tryCancel(Promise<?> p, InternalLogger logger) {
        if (!p.cancel(false) && logger != null) {
            Throwable err2 = p.cause();
            if (err2 == null) {
                logger.warn("Failed to cancel promise because it has succeeded already: {}", (Object)p);
            } else {
                logger.warn("Failed to cancel promise because it has failed already: {}, unnotified cause:", (Object)p, (Object)err2);
            }
        }
    }

    public static <V> void trySuccess(Promise<? super V> p, V result2, InternalLogger logger) {
        if (!p.trySuccess(result2) && logger != null) {
            Throwable err2 = p.cause();
            if (err2 == null) {
                logger.warn("Failed to mark a promise as success because it has succeeded already: {}", (Object)p);
            } else {
                logger.warn("Failed to mark a promise as success because it has failed already: {}, unnotified cause:", (Object)p, (Object)err2);
            }
        }
    }

    public static void tryFailure(Promise<?> p, Throwable cause, InternalLogger logger) {
        if (!p.tryFailure(cause) && logger != null) {
            Throwable err2 = p.cause();
            if (err2 == null) {
                logger.warn("Failed to mark a promise as failure because it has succeeded already: {}", (Object)p, (Object)cause);
            } else {
                logger.warn("Failed to mark a promise as failure because it has failed already: {}, unnotified cause: {}", p, ThrowableUtil.stackTraceToString(err2), cause);
            }
        }
    }
}

