/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.util.internal;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import play.shaded.ahc.io.netty.util.NetUtil;
import play.shaded.ahc.io.netty.util.internal.EmptyArrays;
import play.shaded.ahc.io.netty.util.internal.PlatformDependent;
import play.shaded.ahc.io.netty.util.internal.SocketUtils;
import play.shaded.ahc.io.netty.util.internal.StringUtil;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLogger;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLoggerFactory;

public final class MacAddressUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MacAddressUtil.class);
    private static final int EUI64_MAC_ADDRESS_LENGTH = 8;
    private static final int EUI48_MAC_ADDRESS_LENGTH = 6;

    public static byte[] bestAvailableMac() {
        byte[] bestMacAddr = EmptyArrays.EMPTY_BYTES;
        InetAddress bestInetAddr = NetUtil.LOCALHOST4;
        LinkedHashMap<NetworkInterface, InetAddress> ifaces = new LinkedHashMap<NetworkInterface, InetAddress>();
        try {
            Enumeration<NetworkInterface> interfaces2 = NetworkInterface.getNetworkInterfaces();
            if (interfaces2 != null) {
                while (interfaces2.hasMoreElements()) {
                    InetAddress a2;
                    NetworkInterface iface = interfaces2.nextElement();
                    Enumeration<InetAddress> addrs = SocketUtils.addressesFromNetworkInterface(iface);
                    if (!addrs.hasMoreElements() || (a2 = addrs.nextElement()).isLoopbackAddress()) continue;
                    ifaces.put(iface, a2);
                }
            }
        }
        catch (SocketException e) {
            logger.warn("Failed to retrieve the list of available network interfaces", e);
        }
        for (Map.Entry entry2 : ifaces.entrySet()) {
            byte[] macAddr;
            NetworkInterface iface = (NetworkInterface)entry2.getKey();
            InetAddress inetAddr = (InetAddress)entry2.getValue();
            if (iface.isVirtual()) continue;
            try {
                macAddr = SocketUtils.hardwareAddressFromNetworkInterface(iface);
            }
            catch (SocketException e) {
                logger.debug("Failed to get the hardware address of a network interface: {}", (Object)iface, (Object)e);
                continue;
            }
            boolean replace2 = false;
            int res = MacAddressUtil.compareAddresses(bestMacAddr, macAddr);
            if (res < 0) {
                replace2 = true;
            } else if (res == 0) {
                res = MacAddressUtil.compareAddresses(bestInetAddr, inetAddr);
                if (res < 0) {
                    replace2 = true;
                } else if (res == 0 && bestMacAddr.length < macAddr.length) {
                    replace2 = true;
                }
            }
            if (!replace2) continue;
            bestMacAddr = macAddr;
            bestInetAddr = inetAddr;
        }
        if (bestMacAddr == EmptyArrays.EMPTY_BYTES) {
            return null;
        }
        switch (bestMacAddr.length) {
            case 6: {
                byte[] newAddr = new byte[8];
                System.arraycopy(bestMacAddr, 0, newAddr, 0, 3);
                newAddr[3] = -1;
                newAddr[4] = -2;
                System.arraycopy(bestMacAddr, 3, newAddr, 5, 3);
                bestMacAddr = newAddr;
                break;
            }
            default: {
                bestMacAddr = Arrays.copyOf(bestMacAddr, 8);
            }
        }
        return bestMacAddr;
    }

    public static byte[] defaultMachineId() {
        byte[] bestMacAddr = MacAddressUtil.bestAvailableMac();
        if (bestMacAddr == null) {
            bestMacAddr = new byte[8];
            PlatformDependent.threadLocalRandom().nextBytes(bestMacAddr);
            logger.warn("Failed to find a usable hardware address from the network interfaces; using random bytes: {}", (Object)MacAddressUtil.formatAddress(bestMacAddr));
        }
        return bestMacAddr;
    }

    public static byte[] parseMAC(String value2) {
        byte[] machineId;
        char separator;
        switch (value2.length()) {
            case 17: {
                separator = value2.charAt(2);
                MacAddressUtil.validateMacSeparator(separator);
                machineId = new byte[6];
                break;
            }
            case 23: {
                separator = value2.charAt(2);
                MacAddressUtil.validateMacSeparator(separator);
                machineId = new byte[8];
                break;
            }
            default: {
                throw new IllegalArgumentException("value is not supported [MAC-48, EUI-48, EUI-64]");
            }
        }
        int end = machineId.length - 1;
        int j = 0;
        int i = 0;
        while (i < end) {
            int sIndex = j + 2;
            machineId[i] = StringUtil.decodeHexByte(value2, j);
            if (value2.charAt(sIndex) != separator) {
                throw new IllegalArgumentException("expected separator '" + separator + " but got '" + value2.charAt(sIndex) + "' at index: " + sIndex);
            }
            ++i;
            j += 3;
        }
        machineId[end] = StringUtil.decodeHexByte(value2, j);
        return machineId;
    }

    private static void validateMacSeparator(char separator) {
        if (separator != ':' && separator != '-') {
            throw new IllegalArgumentException("unsupported separator: " + separator + " (expected: [:-])");
        }
    }

    public static String formatAddress(byte[] addr) {
        StringBuilder buf = new StringBuilder(24);
        for (byte b2 : addr) {
            buf.append(String.format("%02x:", b2 & 0xFF));
        }
        return buf.substring(0, buf.length() - 1);
    }

    static int compareAddresses(byte[] current, byte[] candidate) {
        if (candidate == null || candidate.length < 6) {
            return 1;
        }
        boolean onlyZeroAndOne = true;
        for (byte b2 : candidate) {
            if (b2 == 0 || b2 == 1) continue;
            onlyZeroAndOne = false;
            break;
        }
        if (onlyZeroAndOne) {
            return 1;
        }
        if ((candidate[0] & 1) != 0) {
            return 1;
        }
        if ((candidate[0] & 2) == 0) {
            if (current.length != 0 && (current[0] & 2) == 0) {
                return 0;
            }
            return -1;
        }
        if (current.length != 0 && (current[0] & 2) == 0) {
            return 1;
        }
        return 0;
    }

    private static int compareAddresses(InetAddress current, InetAddress candidate) {
        return MacAddressUtil.scoreAddress(current) - MacAddressUtil.scoreAddress(candidate);
    }

    private static int scoreAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return 0;
        }
        if (addr.isMulticastAddress()) {
            return 1;
        }
        if (addr.isLinkLocalAddress()) {
            return 2;
        }
        if (addr.isSiteLocalAddress()) {
            return 3;
        }
        return 4;
    }

    private MacAddressUtil() {
    }
}

