/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.util.concurrent;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import play.shaded.ahc.io.netty.util.concurrent.DefaultProgressivePromise;
import play.shaded.ahc.io.netty.util.concurrent.DefaultPromise;
import play.shaded.ahc.io.netty.util.concurrent.DefaultThreadFactory;
import play.shaded.ahc.io.netty.util.concurrent.EventExecutor;
import play.shaded.ahc.io.netty.util.concurrent.EventExecutorGroup;
import play.shaded.ahc.io.netty.util.concurrent.FailedFuture;
import play.shaded.ahc.io.netty.util.concurrent.Future;
import play.shaded.ahc.io.netty.util.concurrent.GlobalEventExecutor;
import play.shaded.ahc.io.netty.util.concurrent.ProgressivePromise;
import play.shaded.ahc.io.netty.util.concurrent.Promise;
import play.shaded.ahc.io.netty.util.concurrent.PromiseTask;
import play.shaded.ahc.io.netty.util.concurrent.ScheduledFuture;
import play.shaded.ahc.io.netty.util.concurrent.SucceededFuture;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLogger;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLoggerFactory;

public final class UnorderedThreadPoolEventExecutor
extends ScheduledThreadPoolExecutor
implements EventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(UnorderedThreadPoolEventExecutor.class);
    private final Promise<?> terminationFuture = GlobalEventExecutor.INSTANCE.newPromise();
    private final Set<EventExecutor> executorSet = Collections.singleton(this);

    public UnorderedThreadPoolEventExecutor(int corePoolSize) {
        this(corePoolSize, new DefaultThreadFactory(UnorderedThreadPoolEventExecutor.class));
    }

    public UnorderedThreadPoolEventExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public UnorderedThreadPoolEventExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        this(corePoolSize, new DefaultThreadFactory(UnorderedThreadPoolEventExecutor.class), handler);
    }

    public UnorderedThreadPoolEventExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    public EventExecutor next() {
        return this;
    }

    @Override
    public EventExecutorGroup parent() {
        return this;
    }

    @Override
    public boolean inEventLoop() {
        return false;
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return false;
    }

    @Override
    public <V> Promise<V> newPromise() {
        return new DefaultPromise(this);
    }

    @Override
    public <V> ProgressivePromise<V> newProgressivePromise() {
        return new DefaultProgressivePromise(this);
    }

    @Override
    public <V> Future<V> newSucceededFuture(V result2) {
        return new SucceededFuture<V>(this, result2);
    }

    @Override
    public <V> Future<V> newFailedFuture(Throwable cause) {
        return new FailedFuture(this, cause);
    }

    @Override
    public boolean isShuttingDown() {
        return this.isShutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> tasks = super.shutdownNow();
        this.terminationFuture.trySuccess(null);
        return tasks;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.terminationFuture.trySuccess(null);
    }

    @Override
    public Future<?> shutdownGracefully() {
        return this.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
    }

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit2) {
        this.shutdown();
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.executorSet.iterator();
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task2) {
        return runnable instanceof NonNotifyRunnable ? task2 : new RunnableScheduledFutureTask((EventExecutor)this, runnable, task2);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable2, RunnableScheduledFuture<V> task2) {
        return new RunnableScheduledFutureTask<V>((EventExecutor)this, callable2, task2);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay2, TimeUnit unit2) {
        return (ScheduledFuture)super.schedule(command, delay2, unit2);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable2, long delay2, TimeUnit unit2) {
        return (ScheduledFuture)super.schedule(callable2, delay2, unit2);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit2) {
        return (ScheduledFuture)super.scheduleAtFixedRate(command, initialDelay, period, unit2);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay2, TimeUnit unit2) {
        return (ScheduledFuture)super.scheduleWithFixedDelay(command, initialDelay, delay2, unit2);
    }

    @Override
    public Future<?> submit(Runnable task2) {
        return (Future)super.submit(task2);
    }

    @Override
    public <T> Future<T> submit(Runnable task2, T result2) {
        return (Future)super.submit(task2, result2);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task2) {
        return (Future)super.submit(task2);
    }

    @Override
    public void execute(Runnable command) {
        super.schedule(new NonNotifyRunnable(command), 0L, TimeUnit.NANOSECONDS);
    }

    private static final class NonNotifyRunnable
    implements Runnable {
        private final Runnable task;

        NonNotifyRunnable(Runnable task2) {
            this.task = task2;
        }

        @Override
        public void run() {
            this.task.run();
        }
    }

    private static final class RunnableScheduledFutureTask<V>
    extends PromiseTask<V>
    implements RunnableScheduledFuture<V>,
    ScheduledFuture<V> {
        private final RunnableScheduledFuture<V> future;

        RunnableScheduledFutureTask(EventExecutor executor, Runnable runnable, RunnableScheduledFuture<V> future2) {
            super(executor, runnable, null);
            this.future = future2;
        }

        RunnableScheduledFutureTask(EventExecutor executor, Callable<V> callable2, RunnableScheduledFuture<V> future2) {
            super(executor, callable2);
            this.future = future2;
        }

        @Override
        public void run() {
            block5: {
                if (!this.isPeriodic()) {
                    super.run();
                } else if (!this.isDone()) {
                    try {
                        this.task.call();
                    }
                    catch (Throwable cause) {
                        if (this.tryFailureInternal(cause)) break block5;
                        logger.warn("Failure during execution of task", cause);
                    }
                }
            }
        }

        @Override
        public boolean isPeriodic() {
            return this.future.isPeriodic();
        }

        @Override
        public long getDelay(TimeUnit unit2) {
            return this.future.getDelay(unit2);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.future.compareTo(o);
        }
    }
}

