/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.util.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import play.shaded.ahc.io.netty.util.concurrent.RejectedExecutionHandler;
import play.shaded.ahc.io.netty.util.concurrent.SingleThreadEventExecutor;
import play.shaded.ahc.io.netty.util.internal.ObjectUtil;

public final class RejectedExecutionHandlers {
    private static final RejectedExecutionHandler REJECT = new RejectedExecutionHandler(){

        @Override
        public void rejected(Runnable task2, SingleThreadEventExecutor executor) {
            throw new RejectedExecutionException();
        }
    };

    private RejectedExecutionHandlers() {
    }

    public static RejectedExecutionHandler reject() {
        return REJECT;
    }

    public static RejectedExecutionHandler backoff(final int retries, long backoffAmount, TimeUnit unit2) {
        ObjectUtil.checkPositive(retries, "retries");
        final long backOffNanos = unit2.toNanos(backoffAmount);
        return new RejectedExecutionHandler(){

            @Override
            public void rejected(Runnable task2, SingleThreadEventExecutor executor) {
                if (!executor.inEventLoop()) {
                    for (int i = 0; i < retries; ++i) {
                        executor.wakeup(false);
                        LockSupport.parkNanos(backOffNanos);
                        if (!executor.offerTask(task2)) continue;
                        return;
                    }
                }
                throw new RejectedExecutionException();
            }
        };
    }
}

