/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.util.concurrent;

import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import play.shaded.ahc.io.netty.util.concurrent.AbstractEventExecutor;
import play.shaded.ahc.io.netty.util.concurrent.EventExecutorGroup;
import play.shaded.ahc.io.netty.util.concurrent.ScheduledFuture;
import play.shaded.ahc.io.netty.util.concurrent.ScheduledFutureTask;
import play.shaded.ahc.io.netty.util.internal.DefaultPriorityQueue;
import play.shaded.ahc.io.netty.util.internal.ObjectUtil;
import play.shaded.ahc.io.netty.util.internal.PriorityQueue;

public abstract class AbstractScheduledEventExecutor
extends AbstractEventExecutor {
    private static final Comparator<ScheduledFutureTask<?>> SCHEDULED_FUTURE_TASK_COMPARATOR = new Comparator<ScheduledFutureTask<?>>(){

        @Override
        public int compare(ScheduledFutureTask<?> o1, ScheduledFutureTask<?> o2) {
            return o1.compareTo(o2);
        }
    };
    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue;

    protected AbstractScheduledEventExecutor() {
    }

    protected AbstractScheduledEventExecutor(EventExecutorGroup parent2) {
        super(parent2);
    }

    protected static long nanoTime() {
        return ScheduledFutureTask.nanoTime();
    }

    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue() {
        if (this.scheduledTaskQueue == null) {
            this.scheduledTaskQueue = new DefaultPriorityQueue(SCHEDULED_FUTURE_TASK_COMPARATOR, 11);
        }
        return this.scheduledTaskQueue;
    }

    private static boolean isNullOrEmpty(Queue<ScheduledFutureTask<?>> queue2) {
        return queue2 == null || queue2.isEmpty();
    }

    protected void cancelScheduledTasks() {
        ScheduledFutureTask[] scheduledTasks;
        assert (this.inEventLoop());
        PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        if (AbstractScheduledEventExecutor.isNullOrEmpty(scheduledTaskQueue)) {
            return;
        }
        for (ScheduledFutureTask task2 : scheduledTasks = scheduledTaskQueue.toArray(new ScheduledFutureTask[0])) {
            task2.cancelWithoutRemove(false);
        }
        scheduledTaskQueue.clearIgnoringIndexes();
    }

    protected final Runnable pollScheduledTask() {
        return this.pollScheduledTask(AbstractScheduledEventExecutor.nanoTime());
    }

    protected final Runnable pollScheduledTask(long nanoTime) {
        ScheduledFutureTask scheduledTask;
        assert (this.inEventLoop());
        PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        ScheduledFutureTask scheduledFutureTask = scheduledTask = scheduledTaskQueue == null ? null : (ScheduledFutureTask)scheduledTaskQueue.peek();
        if (scheduledTask == null) {
            return null;
        }
        if (scheduledTask.deadlineNanos() <= nanoTime) {
            scheduledTaskQueue.remove();
            return scheduledTask;
        }
        return null;
    }

    protected final long nextScheduledTaskNano() {
        ScheduledFutureTask scheduledTask;
        PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        ScheduledFutureTask scheduledFutureTask = scheduledTask = scheduledTaskQueue == null ? null : (ScheduledFutureTask)scheduledTaskQueue.peek();
        if (scheduledTask == null) {
            return -1L;
        }
        return Math.max(0L, scheduledTask.deadlineNanos() - AbstractScheduledEventExecutor.nanoTime());
    }

    final ScheduledFutureTask<?> peekScheduledTask() {
        PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        if (scheduledTaskQueue == null) {
            return null;
        }
        return (ScheduledFutureTask)scheduledTaskQueue.peek();
    }

    protected final boolean hasScheduledTasks() {
        PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        ScheduledFutureTask scheduledTask = scheduledTaskQueue == null ? null : (ScheduledFutureTask)scheduledTaskQueue.peek();
        return scheduledTask != null && scheduledTask.deadlineNanos() <= AbstractScheduledEventExecutor.nanoTime();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay2, TimeUnit unit2) {
        ObjectUtil.checkNotNull(command, "command");
        ObjectUtil.checkNotNull(unit2, "unit");
        if (delay2 < 0L) {
            delay2 = 0L;
        }
        this.validateScheduled0(delay2, unit2);
        return this.schedule(new ScheduledFutureTask<Object>(this, command, null, ScheduledFutureTask.deadlineNanos(unit2.toNanos(delay2))));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable2, long delay2, TimeUnit unit2) {
        ObjectUtil.checkNotNull(callable2, "callable");
        ObjectUtil.checkNotNull(unit2, "unit");
        if (delay2 < 0L) {
            delay2 = 0L;
        }
        this.validateScheduled0(delay2, unit2);
        return this.schedule(new ScheduledFutureTask<V>(this, callable2, ScheduledFutureTask.deadlineNanos(unit2.toNanos(delay2))));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit2) {
        ObjectUtil.checkNotNull(command, "command");
        ObjectUtil.checkNotNull(unit2, "unit");
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (period <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", period));
        }
        this.validateScheduled0(initialDelay, unit2);
        this.validateScheduled0(period, unit2);
        return this.schedule(new ScheduledFutureTask<Object>(this, Executors.callable(command, null), ScheduledFutureTask.deadlineNanos(unit2.toNanos(initialDelay)), unit2.toNanos(period)));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay2, TimeUnit unit2) {
        ObjectUtil.checkNotNull(command, "command");
        ObjectUtil.checkNotNull(unit2, "unit");
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (delay2 <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", delay2));
        }
        this.validateScheduled0(initialDelay, unit2);
        this.validateScheduled0(delay2, unit2);
        return this.schedule(new ScheduledFutureTask<Object>(this, Executors.callable(command, null), ScheduledFutureTask.deadlineNanos(unit2.toNanos(initialDelay)), -unit2.toNanos(delay2)));
    }

    private void validateScheduled0(long amount, TimeUnit unit2) {
        this.validateScheduled(amount, unit2);
    }

    @Deprecated
    protected void validateScheduled(long amount, TimeUnit unit2) {
    }

    <V> ScheduledFuture<V> schedule(final ScheduledFutureTask<V> task2) {
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().add(task2);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractScheduledEventExecutor.this.scheduledTaskQueue().add(task2);
                }
            });
        }
        return task2;
    }

    final void removeScheduled(final ScheduledFutureTask<?> task2) {
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().removeTyped(task2);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractScheduledEventExecutor.this.removeScheduled(task2);
                }
            });
        }
    }
}

