/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.resolver.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import play.shaded.ahc.io.netty.channel.EventLoop;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecordType;
import play.shaded.ahc.io.netty.resolver.dns.AuthoritativeDnsServerCache;
import play.shaded.ahc.io.netty.resolver.dns.DnsAddressDecoder;
import play.shaded.ahc.io.netty.resolver.dns.DnsCache;
import play.shaded.ahc.io.netty.resolver.dns.DnsNameResolver;
import play.shaded.ahc.io.netty.resolver.dns.DnsResolveContext;
import play.shaded.ahc.io.netty.resolver.dns.DnsServerAddressStream;
import play.shaded.ahc.io.netty.util.concurrent.Promise;

final class DnsAddressResolveContext
extends DnsResolveContext<InetAddress> {
    private final DnsCache resolveCache;
    private final AuthoritativeDnsServerCache authoritativeDnsServerCache;

    DnsAddressResolveContext(DnsNameResolver parent2, String hostname, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs, DnsCache resolveCache, AuthoritativeDnsServerCache authoritativeDnsServerCache) {
        super(parent2, hostname, 1, parent2.resolveRecordTypes(), additionals, nameServerAddrs);
        this.resolveCache = resolveCache;
        this.authoritativeDnsServerCache = authoritativeDnsServerCache;
    }

    @Override
    DnsResolveContext<InetAddress> newResolverContext(DnsNameResolver parent2, String hostname, int dnsClass, DnsRecordType[] expectedTypes2, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs) {
        return new DnsAddressResolveContext(parent2, hostname, additionals, nameServerAddrs, this.resolveCache, this.authoritativeDnsServerCache);
    }

    @Override
    InetAddress convertRecord(DnsRecord record2, String hostname, DnsRecord[] additionals, EventLoop eventLoop) {
        return DnsAddressDecoder.decodeAddress(record2, hostname, this.parent.isDecodeIdn());
    }

    @Override
    List<InetAddress> filterResults(List<InetAddress> unfiltered) {
        Class<? extends InetAddress> inetAddressType = this.parent.preferredAddressType().addressType();
        int size2 = unfiltered.size();
        int numExpected = 0;
        for (int i = 0; i < size2; ++i) {
            InetAddress address = unfiltered.get(i);
            if (!inetAddressType.isInstance(address)) continue;
            ++numExpected;
        }
        if (numExpected == size2 || numExpected == 0) {
            return unfiltered;
        }
        ArrayList<InetAddress> filtered2 = new ArrayList<InetAddress>(numExpected);
        for (int i = 0; i < size2; ++i) {
            InetAddress address = unfiltered.get(i);
            if (!inetAddressType.isInstance(address)) continue;
            filtered2.add(address);
        }
        return filtered2;
    }

    @Override
    void cache(String hostname, DnsRecord[] additionals, DnsRecord result2, InetAddress convertedResult) {
        this.resolveCache.cache(hostname, additionals, convertedResult, result2.timeToLive(), this.parent.ch.eventLoop());
    }

    @Override
    void cache(String hostname, DnsRecord[] additionals, UnknownHostException cause) {
        this.resolveCache.cache(hostname, additionals, cause, this.parent.ch.eventLoop());
    }

    @Override
    void doSearchDomainQuery(String hostname, Promise<List<InetAddress>> nextPromise) {
        if (!DnsNameResolver.doResolveAllCached(hostname, this.additionals, nextPromise, this.resolveCache, this.parent.resolvedInternetProtocolFamiliesUnsafe())) {
            super.doSearchDomainQuery(hostname, nextPromise);
        }
    }

    @Override
    DnsCache resolveCache() {
        return this.resolveCache;
    }

    @Override
    AuthoritativeDnsServerCache authoritativeDnsServerCache() {
        return this.authoritativeDnsServerCache;
    }
}

