/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.resolver.dns;

import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBufHolder;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRawRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecord;

final class DnsAddressDecoder {
    private static final int INADDRSZ4 = 4;
    private static final int INADDRSZ6 = 16;

    static InetAddress decodeAddress(DnsRecord record2, String name, boolean decodeIdn) {
        if (!(record2 instanceof DnsRawRecord)) {
            return null;
        }
        ByteBuf content = ((ByteBufHolder)((Object)record2)).content();
        int contentLen = content.readableBytes();
        if (contentLen != 4 && contentLen != 16) {
            return null;
        }
        byte[] addrBytes = new byte[contentLen];
        content.getBytes(content.readerIndex(), addrBytes);
        try {
            return InetAddress.getByAddress(decodeIdn ? IDN.toUnicode(name) : name, addrBytes);
        }
        catch (UnknownHostException e) {
            throw new Error(e);
        }
    }

    private DnsAddressDecoder() {
    }
}

