/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.resolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import play.shaded.ahc.io.netty.resolver.InetNameResolver;
import play.shaded.ahc.io.netty.resolver.NameResolver;
import play.shaded.ahc.io.netty.util.concurrent.EventExecutor;
import play.shaded.ahc.io.netty.util.concurrent.Future;
import play.shaded.ahc.io.netty.util.concurrent.FutureListener;
import play.shaded.ahc.io.netty.util.concurrent.GenericFutureListener;
import play.shaded.ahc.io.netty.util.concurrent.Promise;
import play.shaded.ahc.io.netty.util.internal.PlatformDependent;

public class RoundRobinInetAddressResolver
extends InetNameResolver {
    private final NameResolver<InetAddress> nameResolver;

    public RoundRobinInetAddressResolver(EventExecutor executor, NameResolver<InetAddress> nameResolver) {
        super(executor);
        this.nameResolver = nameResolver;
    }

    @Override
    protected void doResolve(final String inetHost, final Promise<InetAddress> promise) throws Exception {
        this.nameResolver.resolveAll(inetHost).addListener((GenericFutureListener<Future<List<InetAddress>>>)new FutureListener<List<InetAddress>>(){

            @Override
            public void operationComplete(Future<List<InetAddress>> future2) throws Exception {
                if (future2.isSuccess()) {
                    List<InetAddress> inetAddresses = future2.getNow();
                    int numAddresses = inetAddresses.size();
                    if (numAddresses > 0) {
                        promise.setSuccess(inetAddresses.get(RoundRobinInetAddressResolver.randomIndex(numAddresses)));
                    } else {
                        promise.setFailure(new UnknownHostException(inetHost));
                    }
                } else {
                    promise.setFailure(future2.cause());
                }
            }
        });
    }

    @Override
    protected void doResolveAll(String inetHost, final Promise<List<InetAddress>> promise) throws Exception {
        this.nameResolver.resolveAll(inetHost).addListener((GenericFutureListener<Future<List<InetAddress>>>)new FutureListener<List<InetAddress>>(){

            @Override
            public void operationComplete(Future<List<InetAddress>> future2) throws Exception {
                if (future2.isSuccess()) {
                    List<InetAddress> inetAddresses = future2.getNow();
                    if (!inetAddresses.isEmpty()) {
                        ArrayList<InetAddress> result2 = new ArrayList<InetAddress>(inetAddresses);
                        Collections.rotate(result2, RoundRobinInetAddressResolver.randomIndex(inetAddresses.size()));
                        promise.setSuccess(result2);
                    } else {
                        promise.setSuccess(inetAddresses);
                    }
                } else {
                    promise.setFailure(future2.cause());
                }
            }
        });
    }

    private static int randomIndex(int numAddresses) {
        return numAddresses == 1 ? 0 : PlatformDependent.threadLocalRandom().nextInt(numAddresses);
    }
}

