/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.timeout;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import play.shaded.ahc.io.netty.channel.ChannelFuture;
import play.shaded.ahc.io.netty.channel.ChannelFutureListener;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.channel.ChannelOutboundHandlerAdapter;
import play.shaded.ahc.io.netty.channel.ChannelPromise;
import play.shaded.ahc.io.netty.handler.timeout.WriteTimeoutException;

public class WriteTimeoutHandler
extends ChannelOutboundHandlerAdapter {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long timeoutNanos;
    private WriteTimeoutTask lastTask;
    private boolean closed;

    public WriteTimeoutHandler(int timeoutSeconds) {
        this(timeoutSeconds, TimeUnit.SECONDS);
    }

    public WriteTimeoutHandler(long timeout, TimeUnit unit2) {
        if (unit2 == null) {
            throw new NullPointerException("unit");
        }
        this.timeoutNanos = timeout <= 0L ? 0L : Math.max(unit2.toNanos(timeout), MIN_TIMEOUT_NANOS);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.timeoutNanos > 0L) {
            promise = promise.unvoid();
            this.scheduleTimeout(ctx, promise);
        }
        ctx.write(msg, promise);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        WriteTimeoutTask task2 = this.lastTask;
        this.lastTask = null;
        while (task2 != null) {
            task2.scheduledFuture.cancel(false);
            WriteTimeoutTask prev = task2.prev;
            task2.prev = null;
            task2.next = null;
            task2 = prev;
        }
    }

    private void scheduleTimeout(ChannelHandlerContext ctx, ChannelPromise promise) {
        WriteTimeoutTask task2 = new WriteTimeoutTask(ctx, promise);
        task2.scheduledFuture = ctx.executor().schedule(task2, this.timeoutNanos, TimeUnit.NANOSECONDS);
        if (!task2.scheduledFuture.isDone()) {
            this.addWriteTimeoutTask(task2);
            promise.addListener(task2);
        }
    }

    private void addWriteTimeoutTask(WriteTimeoutTask task2) {
        if (this.lastTask != null) {
            this.lastTask.next = task2;
            task2.prev = this.lastTask;
        }
        this.lastTask = task2;
    }

    private void removeWriteTimeoutTask(WriteTimeoutTask task2) {
        if (task2 == this.lastTask) {
            assert (task2.next == null);
            this.lastTask = this.lastTask.prev;
            if (this.lastTask != null) {
                this.lastTask.next = null;
            }
        } else {
            if (task2.prev == null && task2.next == null) {
                return;
            }
            if (task2.prev == null) {
                task2.next.prev = null;
            } else {
                task2.prev.next = task2.next;
                task2.next.prev = task2.prev;
            }
        }
        task2.prev = null;
        task2.next = null;
    }

    protected void writeTimedOut(ChannelHandlerContext ctx) throws Exception {
        if (!this.closed) {
            ctx.fireExceptionCaught(WriteTimeoutException.INSTANCE);
            ctx.close();
            this.closed = true;
        }
    }

    private final class WriteTimeoutTask
    implements Runnable,
    ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;
        WriteTimeoutTask prev;
        WriteTimeoutTask next;
        ScheduledFuture<?> scheduledFuture;

        WriteTimeoutTask(ChannelHandlerContext ctx, ChannelPromise promise) {
            this.ctx = ctx;
            this.promise = promise;
        }

        @Override
        public void run() {
            if (!this.promise.isDone()) {
                try {
                    WriteTimeoutHandler.this.writeTimedOut(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireExceptionCaught(t);
                }
            }
            WriteTimeoutHandler.this.removeWriteTimeoutTask(this);
        }

        @Override
        public void operationComplete(ChannelFuture future2) throws Exception {
            this.scheduledFuture.cancel(false);
            WriteTimeoutHandler.this.removeWriteTimeoutTask(this);
        }
    }
}

