/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.ssl;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import play.shaded.ahc.io.netty.buffer.ByteBufAllocator;
import play.shaded.ahc.io.netty.handler.ssl.DefaultOpenSslKeyMaterial;
import play.shaded.ahc.io.netty.handler.ssl.OpenSslKeyMaterial;
import play.shaded.ahc.io.netty.handler.ssl.OpenSslPrivateKey;
import play.shaded.ahc.io.netty.handler.ssl.PemEncoded;
import play.shaded.ahc.io.netty.handler.ssl.PemX509Certificate;
import play.shaded.ahc.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import play.shaded.ahc.io.netty.internal.tcnative.SSL;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialProvider(X509KeyManager keyManager, String password) {
        this.keyManager = keyManager;
        this.password = password;
    }

    X509KeyManager keyManager() {
        return this.keyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias) throws Exception {
        X509Certificate[] certificates = this.keyManager.getCertificateChain(alias);
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        PrivateKey key = this.keyManager.getPrivateKey(alias);
        PemEncoded encoded = PemX509Certificate.toPEM(allocator, true, certificates);
        long chainBio = 0L;
        long pkeyBio = 0L;
        long chain2 = 0L;
        long pkey = 0L;
        try {
            OpenSslKeyMaterial keyMaterial;
            chainBio = ReferenceCountedOpenSslContext.toBIO(allocator, encoded.retain());
            chain2 = SSL.parseX509Chain((long)chainBio);
            if (key instanceof OpenSslPrivateKey) {
                keyMaterial = ((OpenSslPrivateKey)key).toKeyMaterial(chain2);
            } else {
                pkeyBio = ReferenceCountedOpenSslContext.toBIO(allocator, key);
                pkey = key == null ? 0L : SSL.parsePrivateKey((long)pkeyBio, (String)this.password);
                keyMaterial = new DefaultOpenSslKeyMaterial(chain2, pkey);
            }
            chain2 = 0L;
            pkey = 0L;
            OpenSslKeyMaterial openSslKeyMaterial = keyMaterial;
            return openSslKeyMaterial;
        }
        finally {
            SSL.freeBIO((long)chainBio);
            SSL.freeBIO((long)pkeyBio);
            if (chain2 != 0L) {
                SSL.freeX509Chain((long)chain2);
            }
            if (pkey != 0L) {
                SSL.freePrivateKey((long)pkey);
            }
            encoded.release();
        }
    }

    void destroy() {
    }
}

