/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.spdy;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.handler.codec.MessageToMessageCodec;
import play.shaded.ahc.io.netty.handler.codec.http.HttpMessage;
import play.shaded.ahc.io.netty.handler.codec.spdy.SpdyHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import play.shaded.ahc.io.netty.util.ReferenceCountUtil;

public class SpdyHttpResponseStreamIdHandler
extends MessageToMessageCodec<Object, HttpMessage> {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new LinkedList<Integer>();

    @Override
    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof HttpMessage || msg instanceof SpdyRstStreamFrame;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, HttpMessage msg, List<Object> out) throws Exception {
        Integer id2 = this.ids.poll();
        if (id2 != null && id2.intValue() != NO_ID.intValue() && !msg.headers().contains(SpdyHttpHeaders.Names.STREAM_ID)) {
            msg.headers().setInt(SpdyHttpHeaders.Names.STREAM_ID, id2);
        }
        out.add(ReferenceCountUtil.retain(msg));
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        if (msg instanceof HttpMessage) {
            boolean contains2 = ((HttpMessage)msg).headers().contains(SpdyHttpHeaders.Names.STREAM_ID);
            if (!contains2) {
                this.ids.add(NO_ID);
            } else {
                this.ids.add(((HttpMessage)msg).headers().getInt(SpdyHttpHeaders.Names.STREAM_ID));
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            this.ids.remove(((SpdyRstStreamFrame)msg).streamId());
        }
        out.add(ReferenceCountUtil.retain(msg));
    }
}

