/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.spdy;

import java.util.Set;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBufAllocator;
import play.shaded.ahc.io.netty.buffer.ByteBufUtil;
import play.shaded.ahc.io.netty.buffer.Unpooled;
import play.shaded.ahc.io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import play.shaded.ahc.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import play.shaded.ahc.io.netty.handler.codec.spdy.SpdyVersion;

public class SpdyHeaderBlockRawEncoder
extends SpdyHeaderBlockEncoder {
    private final int version;

    public SpdyHeaderBlockRawEncoder(SpdyVersion version2) {
        if (version2 == null) {
            throw new NullPointerException("version");
        }
        this.version = version2.getVersion();
    }

    private static void setLengthField(ByteBuf buffer, int writerIndex, int length2) {
        buffer.setInt(writerIndex, length2);
    }

    private static void writeLengthField(ByteBuf buffer, int length2) {
        buffer.writeInt(length2);
    }

    @Override
    public ByteBuf encode(ByteBufAllocator alloc, SpdyHeadersFrame frame) throws Exception {
        Set names = frame.headers().names();
        int numHeaders = names.size();
        if (numHeaders == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (numHeaders > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        ByteBuf headerBlock = alloc.heapBuffer();
        SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, numHeaders);
        for (CharSequence name : names) {
            SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, name.length());
            ByteBufUtil.writeAscii(headerBlock, name);
            int savedIndex = headerBlock.writerIndex();
            int valueLength = 0;
            SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, valueLength);
            for (CharSequence value2 : frame.headers().getAll(name)) {
                int length2 = value2.length();
                if (length2 <= 0) continue;
                ByteBufUtil.writeAscii(headerBlock, value2);
                headerBlock.writeByte(0);
                valueLength += length2 + 1;
            }
            if (valueLength != 0) {
                --valueLength;
            }
            if (valueLength > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + name);
            }
            if (valueLength <= 0) continue;
            SpdyHeaderBlockRawEncoder.setLengthField(headerBlock, savedIndex, valueLength);
            headerBlock.writerIndex(headerBlock.writerIndex() - 1);
        }
        return headerBlock;
    }

    @Override
    void end() {
    }
}

