/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.spdy;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import play.shaded.ahc.io.netty.handler.codec.CharSequenceValueConverter;
import play.shaded.ahc.io.netty.handler.codec.DefaultHeaders;
import play.shaded.ahc.io.netty.handler.codec.HeadersUtils;
import play.shaded.ahc.io.netty.handler.codec.spdy.SpdyCodecUtil;
import play.shaded.ahc.io.netty.handler.codec.spdy.SpdyHeaders;
import play.shaded.ahc.io.netty.util.AsciiString;

public class DefaultSpdyHeaders
extends DefaultHeaders<CharSequence, CharSequence, SpdyHeaders>
implements SpdyHeaders {
    private static final DefaultHeaders.NameValidator<CharSequence> SpdyNameValidator = new DefaultHeaders.NameValidator<CharSequence>(){

        @Override
        public void validateName(CharSequence name) {
            SpdyCodecUtil.validateHeaderName(name);
        }
    };

    public DefaultSpdyHeaders() {
        this(true);
    }

    public DefaultSpdyHeaders(boolean validate2) {
        super(AsciiString.CASE_INSENSITIVE_HASHER, validate2 ? HeaderValueConverterAndValidator.INSTANCE : CharSequenceValueConverter.INSTANCE, validate2 ? SpdyNameValidator : DefaultHeaders.NameValidator.NOT_NULL);
    }

    @Override
    public String getAsString(CharSequence name) {
        return HeadersUtils.getAsString(this, name);
    }

    @Override
    public List<String> getAllAsString(CharSequence name) {
        return HeadersUtils.getAllAsString(this, name);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iteratorAsString() {
        return HeadersUtils.iteratorAsString(this);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value2) {
        return this.contains(name, value2, false);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value2, boolean ignoreCase) {
        return this.contains(name, value2, ignoreCase ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    private static final class HeaderValueConverterAndValidator
    extends CharSequenceValueConverter {
        public static final HeaderValueConverterAndValidator INSTANCE = new HeaderValueConverterAndValidator();

        private HeaderValueConverterAndValidator() {
        }

        @Override
        public CharSequence convertObject(Object value2) {
            CharSequence seq2 = super.convertObject(value2);
            SpdyCodecUtil.validateHeaderValue(seq2);
            return seq2;
        }
    }
}

