/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.socksx.v5;

import java.util.List;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.handler.codec.DecoderException;
import play.shaded.ahc.io.netty.handler.codec.DecoderResult;
import play.shaded.ahc.io.netty.handler.codec.ReplayingDecoder;
import play.shaded.ahc.io.netty.handler.codec.socksx.SocksVersion;
import play.shaded.ahc.io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import play.shaded.ahc.io.netty.handler.codec.socksx.v5.Socks5AddressDecoder;
import play.shaded.ahc.io.netty.handler.codec.socksx.v5.Socks5AddressType;
import play.shaded.ahc.io.netty.handler.codec.socksx.v5.Socks5CommandStatus;

public class Socks5CommandResponseDecoder
extends ReplayingDecoder<State> {
    private final Socks5AddressDecoder addressDecoder;

    public Socks5CommandResponseDecoder() {
        this(Socks5AddressDecoder.DEFAULT);
    }

    public Socks5CommandResponseDecoder(Socks5AddressDecoder addressDecoder) {
        super(State.INIT);
        if (addressDecoder == null) {
            throw new NullPointerException("addressDecoder");
        }
        this.addressDecoder = addressDecoder;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in2, List<Object> out) throws Exception {
        try {
            switch ((State)((Object)this.state())) {
                case INIT: {
                    byte version2 = in2.readByte();
                    if (version2 != SocksVersion.SOCKS5.byteValue()) {
                        throw new DecoderException("unsupported version: " + version2 + " (expected: " + SocksVersion.SOCKS5.byteValue() + ')');
                    }
                    Socks5CommandStatus status = Socks5CommandStatus.valueOf(in2.readByte());
                    in2.skipBytes(1);
                    Socks5AddressType addrType = Socks5AddressType.valueOf(in2.readByte());
                    String addr = this.addressDecoder.decodeAddress(addrType, in2);
                    int port = in2.readUnsignedShort();
                    out.add(new DefaultSocks5CommandResponse(status, addrType, addr, port));
                    this.checkpoint(State.SUCCESS);
                }
                case SUCCESS: {
                    int readableBytes = this.actualReadableBytes();
                    if (readableBytes <= 0) break;
                    out.add(in2.readRetainedSlice(readableBytes));
                    break;
                }
                case FAILURE: {
                    in2.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception e) {
            this.fail(out, e);
        }
    }

    private void fail(List<Object> out, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException(cause);
        }
        this.checkpoint(State.FAILURE);
        DefaultSocks5CommandResponse m = new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, Socks5AddressType.IPv4, null, 0);
        m.setDecoderResult(DecoderResult.failure(cause));
        out.add(m);
    }

    static enum State {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

