/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.socksx.v4;

import java.util.List;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.handler.codec.DecoderException;
import play.shaded.ahc.io.netty.handler.codec.DecoderResult;
import play.shaded.ahc.io.netty.handler.codec.ReplayingDecoder;
import play.shaded.ahc.io.netty.handler.codec.socksx.v4.DefaultSocks4CommandResponse;
import play.shaded.ahc.io.netty.handler.codec.socksx.v4.Socks4CommandStatus;
import play.shaded.ahc.io.netty.util.NetUtil;

public class Socks4ClientDecoder
extends ReplayingDecoder<State> {
    public Socks4ClientDecoder() {
        super(State.START);
        this.setSingleDecode(true);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in2, List<Object> out) throws Exception {
        try {
            switch ((State)((Object)this.state())) {
                case START: {
                    short version2 = in2.readUnsignedByte();
                    if (version2 != 0) {
                        throw new DecoderException("unsupported reply version: " + version2 + " (expected: 0)");
                    }
                    Socks4CommandStatus status = Socks4CommandStatus.valueOf(in2.readByte());
                    int dstPort = in2.readUnsignedShort();
                    String dstAddr = NetUtil.intToIpAddress(in2.readInt());
                    out.add(new DefaultSocks4CommandResponse(status, dstAddr, dstPort));
                    this.checkpoint(State.SUCCESS);
                }
                case SUCCESS: {
                    int readableBytes = this.actualReadableBytes();
                    if (readableBytes <= 0) break;
                    out.add(in2.readRetainedSlice(readableBytes));
                    break;
                }
                case FAILURE: {
                    in2.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception e) {
            this.fail(out, e);
        }
    }

    private void fail(List<Object> out, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException(cause);
        }
        DefaultSocks4CommandResponse m = new DefaultSocks4CommandResponse(Socks4CommandStatus.REJECTED_OR_FAILED);
        m.setDecoderResult(DecoderResult.failure(cause));
        out.add(m);
        this.checkpoint(State.FAILURE);
    }

    static enum State {
        START,
        SUCCESS,
        FAILURE;

    }
}

