/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.socksx;

import java.util.List;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.channel.ChannelPipeline;
import play.shaded.ahc.io.netty.handler.codec.ByteToMessageDecoder;
import play.shaded.ahc.io.netty.handler.codec.socksx.SocksVersion;
import play.shaded.ahc.io.netty.handler.codec.socksx.v4.Socks4ServerDecoder;
import play.shaded.ahc.io.netty.handler.codec.socksx.v4.Socks4ServerEncoder;
import play.shaded.ahc.io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import play.shaded.ahc.io.netty.handler.codec.socksx.v5.Socks5ServerEncoder;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLogger;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLoggerFactory;

public class SocksPortUnificationServerHandler
extends ByteToMessageDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SocksPortUnificationServerHandler.class);
    private final Socks5ServerEncoder socks5encoder;

    public SocksPortUnificationServerHandler() {
        this(Socks5ServerEncoder.DEFAULT);
    }

    public SocksPortUnificationServerHandler(Socks5ServerEncoder socks5encoder) {
        if (socks5encoder == null) {
            throw new NullPointerException("socks5encoder");
        }
        this.socks5encoder = socks5encoder;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in2, List<Object> out) throws Exception {
        int readerIndex = in2.readerIndex();
        if (in2.writerIndex() == readerIndex) {
            return;
        }
        ChannelPipeline p = ctx.pipeline();
        byte versionVal = in2.getByte(readerIndex);
        SocksVersion version2 = SocksVersion.valueOf(versionVal);
        switch (version2) {
            case SOCKS4a: {
                SocksPortUnificationServerHandler.logKnownVersion(ctx, version2);
                p.addAfter(ctx.name(), null, Socks4ServerEncoder.INSTANCE);
                p.addAfter(ctx.name(), null, new Socks4ServerDecoder());
                break;
            }
            case SOCKS5: {
                SocksPortUnificationServerHandler.logKnownVersion(ctx, version2);
                p.addAfter(ctx.name(), null, this.socks5encoder);
                p.addAfter(ctx.name(), null, new Socks5InitialRequestDecoder());
                break;
            }
            default: {
                SocksPortUnificationServerHandler.logUnknownVersion(ctx, versionVal);
                in2.skipBytes(in2.readableBytes());
                ctx.close();
                return;
            }
        }
        p.remove(this);
    }

    private static void logKnownVersion(ChannelHandlerContext ctx, SocksVersion version2) {
        logger.debug("{} Protocol version: {}({})", (Object)ctx.channel(), (Object)version2);
    }

    private static void logUnknownVersion(ChannelHandlerContext ctx, byte versionVal) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} Unknown protocol version: {}", (Object)ctx.channel(), (Object)(versionVal & 0xFF));
        }
    }
}

