/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.socks;

import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.handler.codec.socks.SocksRequest;
import play.shaded.ahc.io.netty.handler.codec.socks.SocksResponse;
import play.shaded.ahc.io.netty.handler.codec.socks.UnknownSocksRequest;
import play.shaded.ahc.io.netty.handler.codec.socks.UnknownSocksResponse;
import play.shaded.ahc.io.netty.util.CharsetUtil;
import play.shaded.ahc.io.netty.util.internal.StringUtil;

final class SocksCommonUtils {
    public static final SocksRequest UNKNOWN_SOCKS_REQUEST = new UnknownSocksRequest();
    public static final SocksResponse UNKNOWN_SOCKS_RESPONSE = new UnknownSocksResponse();
    private static final char ipv6hextetSeparator = ':';

    private SocksCommonUtils() {
    }

    public static String ipv6toStr(byte[] src) {
        assert (src.length == 16);
        StringBuilder sb = new StringBuilder(39);
        SocksCommonUtils.ipv6toStr(sb, src, 0, 8);
        return sb.toString();
    }

    private static void ipv6toStr(StringBuilder sb, byte[] src, int fromHextet, int toHextet) {
        int i;
        --toHextet;
        for (i = fromHextet; i < toHextet; ++i) {
            SocksCommonUtils.appendHextet(sb, src, i);
            sb.append(':');
        }
        SocksCommonUtils.appendHextet(sb, src, i);
    }

    private static void appendHextet(StringBuilder sb, byte[] src, int i) {
        StringUtil.toHexString(sb, src, i << 1, 2);
    }

    static String readUsAscii(ByteBuf buffer, int length2) {
        String s2 = buffer.toString(buffer.readerIndex(), length2, CharsetUtil.US_ASCII);
        buffer.skipBytes(length2);
        return s2;
    }
}

