/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.marshalling;

import java.io.IOException;
import org.jboss.marshalling.ByteInput;

class LimitingByteInput
implements ByteInput {
    private static final TooBigObjectException EXCEPTION = new TooBigObjectException();
    private final ByteInput input;
    private final long limit;
    private long read;

    LimitingByteInput(ByteInput input2, long limit2) {
        if (limit2 <= 0L) {
            throw new IllegalArgumentException("The limit MUST be > 0");
        }
        this.input = input2;
        this.limit = limit2;
    }

    public void close() throws IOException {
    }

    public int available() throws IOException {
        return this.readable(this.input.available());
    }

    public int read() throws IOException {
        int readable = this.readable(1);
        if (readable > 0) {
            int b2 = this.input.read();
            ++this.read;
            return b2;
        }
        throw EXCEPTION;
    }

    public int read(byte[] array2) throws IOException {
        return this.read(array2, 0, array2.length);
    }

    public int read(byte[] array2, int offset, int length2) throws IOException {
        int readable = this.readable(length2);
        if (readable > 0) {
            int i = this.input.read(array2, offset, readable);
            this.read += (long)i;
            return i;
        }
        throw EXCEPTION;
    }

    public long skip(long bytes2) throws IOException {
        int readable = this.readable((int)bytes2);
        if (readable > 0) {
            long i = this.input.skip((long)readable);
            this.read += i;
            return i;
        }
        throw EXCEPTION;
    }

    private int readable(int length2) {
        return (int)Math.min((long)length2, this.limit - this.read);
    }

    static final class TooBigObjectException
    extends IOException {
        private static final long serialVersionUID = 1L;

        TooBigObjectException() {
        }
    }
}

