/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.marshalling;

import java.io.IOException;
import org.jboss.marshalling.ByteInput;
import play.shaded.ahc.io.netty.buffer.ByteBuf;

class ChannelBufferByteInput
implements ByteInput {
    private final ByteBuf buffer;

    ChannelBufferByteInput(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public void close() throws IOException {
    }

    public int available() throws IOException {
        return this.buffer.readableBytes();
    }

    public int read() throws IOException {
        if (this.buffer.isReadable()) {
            return this.buffer.readByte() & 0xFF;
        }
        return -1;
    }

    public int read(byte[] array2) throws IOException {
        return this.read(array2, 0, array2.length);
    }

    public int read(byte[] dst, int dstIndex, int length2) throws IOException {
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        length2 = Math.min(available, length2);
        this.buffer.readBytes(dst, dstIndex, length2);
        return length2;
    }

    public long skip(long bytes2) throws IOException {
        int readable = this.buffer.readableBytes();
        if ((long)readable < bytes2) {
            bytes2 = readable;
        }
        this.buffer.readerIndex((int)((long)this.buffer.readerIndex() + bytes2));
        return bytes2;
    }
}

