/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http.websocketx;

import java.net.URI;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker00;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker07;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker08;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketVersion;

public final class WebSocketClientHandshakerFactory {
    private WebSocketClientHandshakerFactory() {
    }

    public static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version2, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders) {
        return WebSocketClientHandshakerFactory.newHandshaker(webSocketURL, version2, subprotocol, allowExtensions, customHeaders, 65536);
    }

    public static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version2, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        return WebSocketClientHandshakerFactory.newHandshaker(webSocketURL, version2, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, true, false);
    }

    public static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version2, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch) {
        if (version2 == WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(webSocketURL, WebSocketVersion.V13, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch);
        }
        if (version2 == WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(webSocketURL, WebSocketVersion.V08, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch);
        }
        if (version2 == WebSocketVersion.V07) {
            return new WebSocketClientHandshaker07(webSocketURL, WebSocketVersion.V07, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch);
        }
        if (version2 == WebSocketVersion.V00) {
            return new WebSocketClientHandshaker00(webSocketURL, WebSocketVersion.V00, subprotocol, customHeaders, maxFramePayloadLength);
        }
        throw new WebSocketHandshakeException("Protocol version " + (Object)((Object)version2) + " not supported.");
    }
}

