/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http.websocketx;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.handler.codec.MessageToMessageEncoder;
import play.shaded.ahc.io.netty.handler.codec.TooLongFrameException;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import play.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import play.shaded.ahc.io.netty.util.ReferenceCounted;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLogger;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLoggerFactory;

public class WebSocket08FrameEncoder
extends MessageToMessageEncoder<WebSocketFrame>
implements WebSocketFrameEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameEncoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private static final int GATHERING_WRITE_THRESHOLD = 1024;
    private final boolean maskPayload;

    public WebSocket08FrameEncoder(boolean maskPayload) {
        this.maskPayload = maskPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        int opcode;
        ByteBuf data = msg.content();
        if (msg instanceof TextWebSocketFrame) {
            opcode = 1;
        } else if (msg instanceof PingWebSocketFrame) {
            opcode = 9;
        } else if (msg instanceof PongWebSocketFrame) {
            opcode = 10;
        } else if (msg instanceof CloseWebSocketFrame) {
            opcode = 8;
        } else if (msg instanceof BinaryWebSocketFrame) {
            opcode = 2;
        } else if (msg instanceof ContinuationWebSocketFrame) {
            opcode = 0;
        } else {
            throw new UnsupportedOperationException("Cannot encode frame of type: " + msg.getClass().getName());
        }
        int length2 = data.readableBytes();
        if (logger.isDebugEnabled()) {
            logger.debug("Encoding WebSocket Frame opCode=" + opcode + " length=" + length2);
        }
        int b0 = 0;
        if (msg.isFinalFragment()) {
            b0 |= 0x80;
        }
        b0 |= msg.rsv() % 8 << 4;
        b0 |= opcode % 128;
        if (opcode == 9 && length2 > 125) {
            throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + length2);
        }
        boolean release2 = true;
        ReferenceCounted buf = null;
        try {
            int size2;
            int maskLength;
            int n = maskLength = this.maskPayload ? 4 : 0;
            if (length2 <= 125) {
                size2 = 2 + maskLength;
                if (this.maskPayload || length2 <= 1024) {
                    size2 += length2;
                }
                buf = ctx.alloc().buffer(size2);
                ((ByteBuf)buf).writeByte(b0);
                byte b2 = this.maskPayload ? (byte)(0x80 | (byte)length2) : (byte)length2;
                ((ByteBuf)buf).writeByte(b2);
            } else if (length2 <= 65535) {
                size2 = 4 + maskLength;
                if (this.maskPayload || length2 <= 1024) {
                    size2 += length2;
                }
                buf = ctx.alloc().buffer(size2);
                ((ByteBuf)buf).writeByte(b0);
                ((ByteBuf)buf).writeByte(this.maskPayload ? 254 : 126);
                ((ByteBuf)buf).writeByte(length2 >>> 8 & 0xFF);
                ((ByteBuf)buf).writeByte(length2 & 0xFF);
            } else {
                size2 = 10 + maskLength;
                if (this.maskPayload || length2 <= 1024) {
                    size2 += length2;
                }
                buf = ctx.alloc().buffer(size2);
                ((ByteBuf)buf).writeByte(b0);
                ((ByteBuf)buf).writeByte(this.maskPayload ? 255 : 127);
                ((ByteBuf)buf).writeLong(length2);
            }
            if (this.maskPayload) {
                int random = (int)(Math.random() * 2.147483647E9);
                byte[] mask = ByteBuffer.allocate(4).putInt(random).array();
                ((ByteBuf)buf).writeBytes(mask);
                ByteOrder srcOrder = data.order();
                ByteOrder dstOrder = ((ByteBuf)buf).order();
                int counter = 0;
                int i = data.readerIndex();
                int end = data.writerIndex();
                if (srcOrder == dstOrder) {
                    int intMask = (mask[0] & 0xFF) << 24 | (mask[1] & 0xFF) << 16 | (mask[2] & 0xFF) << 8 | mask[3] & 0xFF;
                    if (srcOrder == ByteOrder.LITTLE_ENDIAN) {
                        intMask = Integer.reverseBytes(intMask);
                    }
                    while (i + 3 < end) {
                        int intData = data.getInt(i);
                        ((ByteBuf)buf).writeInt(intData ^ intMask);
                        i += 4;
                    }
                }
                while (i < end) {
                    byte byteData = data.getByte(i);
                    ((ByteBuf)buf).writeByte(byteData ^ mask[counter++ % 4]);
                    ++i;
                }
                out.add(buf);
            } else if (((ByteBuf)buf).writableBytes() >= data.readableBytes()) {
                ((ByteBuf)buf).writeBytes(data);
                out.add(buf);
            } else {
                out.add(buf);
                out.add(data.retain());
            }
            release2 = false;
        }
        finally {
            if (release2 && buf != null) {
                buf.release();
            }
        }
    }
}

