/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http.multipart;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import play.shaded.ahc.io.netty.handler.codec.http.HttpConstants;
import play.shaded.ahc.io.netty.handler.codec.http.HttpRequest;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.Attribute;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.DiskAttribute;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.DiskFileUpload;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.FileUpload;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.HttpData;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.HttpDataFactory;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.MemoryAttribute;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.MemoryFileUpload;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.MixedAttribute;
import play.shaded.ahc.io.netty.handler.codec.http.multipart.MixedFileUpload;

public class DefaultHttpDataFactory
implements HttpDataFactory {
    public static final long MINSIZE = 16384L;
    public static final long MAXSIZE = -1L;
    private final boolean useDisk;
    private final boolean checkSize;
    private long minSize;
    private long maxSize = -1L;
    private Charset charset = HttpConstants.DEFAULT_CHARSET;
    private final Map<HttpRequest, List<HttpData>> requestFileDeleteMap = Collections.synchronizedMap(new IdentityHashMap());

    public DefaultHttpDataFactory() {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = 16384L;
    }

    public DefaultHttpDataFactory(Charset charset) {
        this();
        this.charset = charset;
    }

    public DefaultHttpDataFactory(boolean useDisk) {
        this.useDisk = useDisk;
        this.checkSize = false;
    }

    public DefaultHttpDataFactory(boolean useDisk, Charset charset) {
        this(useDisk);
        this.charset = charset;
    }

    public DefaultHttpDataFactory(long minSize) {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = minSize;
    }

    public DefaultHttpDataFactory(long minSize, Charset charset) {
        this(minSize);
        this.charset = charset;
    }

    @Override
    public void setMaxLimit(long maxSize) {
        this.maxSize = maxSize;
    }

    private List<HttpData> getList(HttpRequest request2) {
        List<HttpData> list2 = this.requestFileDeleteMap.get(request2);
        if (list2 == null) {
            list2 = new ArrayList<HttpData>();
            this.requestFileDeleteMap.put(request2, list2);
        }
        return list2;
    }

    @Override
    public Attribute createAttribute(HttpRequest request2, String name) {
        if (this.useDisk) {
            DiskAttribute attribute2 = new DiskAttribute(name, this.charset);
            attribute2.setMaxSize(this.maxSize);
            List<HttpData> list2 = this.getList(request2);
            list2.add(attribute2);
            return attribute2;
        }
        if (this.checkSize) {
            MixedAttribute attribute3 = new MixedAttribute(name, this.minSize, this.charset);
            attribute3.setMaxSize(this.maxSize);
            List<HttpData> list3 = this.getList(request2);
            list3.add(attribute3);
            return attribute3;
        }
        MemoryAttribute attribute4 = new MemoryAttribute(name);
        attribute4.setMaxSize(this.maxSize);
        return attribute4;
    }

    @Override
    public Attribute createAttribute(HttpRequest request2, String name, long definedSize) {
        if (this.useDisk) {
            DiskAttribute attribute2 = new DiskAttribute(name, definedSize, this.charset);
            attribute2.setMaxSize(this.maxSize);
            List<HttpData> list2 = this.getList(request2);
            list2.add(attribute2);
            return attribute2;
        }
        if (this.checkSize) {
            MixedAttribute attribute3 = new MixedAttribute(name, definedSize, this.minSize, this.charset);
            attribute3.setMaxSize(this.maxSize);
            List<HttpData> list3 = this.getList(request2);
            list3.add(attribute3);
            return attribute3;
        }
        MemoryAttribute attribute4 = new MemoryAttribute(name, definedSize);
        attribute4.setMaxSize(this.maxSize);
        return attribute4;
    }

    private static void checkHttpDataSize(HttpData data) {
        try {
            data.checkSize(data.length());
        }
        catch (IOException ignored) {
            throw new IllegalArgumentException("Attribute bigger than maxSize allowed");
        }
    }

    @Override
    public Attribute createAttribute(HttpRequest request2, String name, String value2) {
        if (this.useDisk) {
            Attribute attribute2;
            try {
                attribute2 = new DiskAttribute(name, value2, this.charset);
                attribute2.setMaxSize(this.maxSize);
            }
            catch (IOException e) {
                attribute2 = new MixedAttribute(name, value2, this.minSize, this.charset);
                attribute2.setMaxSize(this.maxSize);
            }
            DefaultHttpDataFactory.checkHttpDataSize(attribute2);
            List<HttpData> list2 = this.getList(request2);
            list2.add(attribute2);
            return attribute2;
        }
        if (this.checkSize) {
            MixedAttribute attribute3 = new MixedAttribute(name, value2, this.minSize, this.charset);
            attribute3.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(attribute3);
            List<HttpData> list3 = this.getList(request2);
            list3.add(attribute3);
            return attribute3;
        }
        try {
            MemoryAttribute attribute4 = new MemoryAttribute(name, value2, this.charset);
            attribute4.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(attribute4);
            return attribute4;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public FileUpload createFileUpload(HttpRequest request2, String name, String filename, String contentType2, String contentTransferEncoding, Charset charset, long size2) {
        if (this.useDisk) {
            DiskFileUpload fileUpload = new DiskFileUpload(name, filename, contentType2, contentTransferEncoding, charset, size2);
            fileUpload.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(fileUpload);
            List<HttpData> list2 = this.getList(request2);
            list2.add(fileUpload);
            return fileUpload;
        }
        if (this.checkSize) {
            MixedFileUpload fileUpload = new MixedFileUpload(name, filename, contentType2, contentTransferEncoding, charset, size2, this.minSize);
            fileUpload.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(fileUpload);
            List<HttpData> list3 = this.getList(request2);
            list3.add(fileUpload);
            return fileUpload;
        }
        MemoryFileUpload fileUpload = new MemoryFileUpload(name, filename, contentType2, contentTransferEncoding, charset, size2);
        fileUpload.setMaxSize(this.maxSize);
        DefaultHttpDataFactory.checkHttpDataSize(fileUpload);
        return fileUpload;
    }

    @Override
    public void removeHttpDataFromClean(HttpRequest request2, InterfaceHttpData data) {
        if (!(data instanceof HttpData)) {
            return;
        }
        List<HttpData> list2 = this.requestFileDeleteMap.get(request2);
        if (list2 == null) {
            return;
        }
        Iterator<HttpData> i = list2.iterator();
        while (i.hasNext()) {
            HttpData n = i.next();
            if (n != data) continue;
            i.remove();
            if (list2.isEmpty()) {
                this.requestFileDeleteMap.remove(request2);
            }
            return;
        }
    }

    @Override
    public void cleanRequestHttpData(HttpRequest request2) {
        List<HttpData> list2 = this.requestFileDeleteMap.remove(request2);
        if (list2 != null) {
            for (HttpData data : list2) {
                data.release();
            }
        }
    }

    @Override
    public void cleanAllHttpData() {
        Iterator<Map.Entry<HttpRequest, List<HttpData>>> i = this.requestFileDeleteMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<HttpRequest, List<HttpData>> e = i.next();
            List<HttpData> list2 = e.getValue();
            for (HttpData data : list2) {
                data.release();
            }
            i.remove();
        }
    }

    @Override
    public void cleanRequestHttpDatas(HttpRequest request2) {
        this.cleanRequestHttpData(request2);
    }

    @Override
    public void cleanAllHttpDatas() {
        this.cleanAllHttpData();
    }
}

