/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http.cookie;

import java.util.BitSet;
import play.shaded.ahc.io.netty.util.internal.InternalThreadLocalMap;

final class CookieUtil {
    private static final BitSet VALID_COOKIE_NAME_OCTETS = CookieUtil.validCookieNameOctets();
    private static final BitSet VALID_COOKIE_VALUE_OCTETS = CookieUtil.validCookieValueOctets();
    private static final BitSet VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS = CookieUtil.validCookieAttributeValueOctets();

    private static BitSet validCookieNameOctets() {
        int[] separators;
        BitSet bits2 = new BitSet();
        for (int i = 32; i < 127; ++i) {
            bits2.set(i);
        }
        for (int separator : separators = new int[]{40, 41, 60, 62, 64, 44, 59, 58, 92, 34, 47, 91, 93, 63, 61, 123, 125, 32, 9}) {
            bits2.set(separator, false);
        }
        return bits2;
    }

    private static BitSet validCookieValueOctets() {
        int i;
        BitSet bits2 = new BitSet();
        bits2.set(33);
        for (i = 35; i <= 43; ++i) {
            bits2.set(i);
        }
        for (i = 45; i <= 58; ++i) {
            bits2.set(i);
        }
        for (i = 60; i <= 91; ++i) {
            bits2.set(i);
        }
        for (i = 93; i <= 126; ++i) {
            bits2.set(i);
        }
        return bits2;
    }

    private static BitSet validCookieAttributeValueOctets() {
        BitSet bits2 = new BitSet();
        for (int i = 32; i < 127; ++i) {
            bits2.set(i);
        }
        bits2.set(59, false);
        return bits2;
    }

    static StringBuilder stringBuilder() {
        return InternalThreadLocalMap.get().stringBuilder();
    }

    static String stripTrailingSeparatorOrNull(StringBuilder buf) {
        return buf.length() == 0 ? null : CookieUtil.stripTrailingSeparator(buf);
    }

    static String stripTrailingSeparator(StringBuilder buf) {
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    static void add(StringBuilder sb, String name, long val) {
        sb.append(name);
        sb.append('=');
        sb.append(val);
        sb.append(';');
        sb.append(' ');
    }

    static void add(StringBuilder sb, String name, String val) {
        sb.append(name);
        sb.append('=');
        sb.append(val);
        sb.append(';');
        sb.append(' ');
    }

    static void add(StringBuilder sb, String name) {
        sb.append(name);
        sb.append(';');
        sb.append(' ');
    }

    static void addQuoted(StringBuilder sb, String name, String val) {
        if (val == null) {
            val = "";
        }
        sb.append(name);
        sb.append('=');
        sb.append('\"');
        sb.append(val);
        sb.append('\"');
        sb.append(';');
        sb.append(' ');
    }

    static int firstInvalidCookieNameOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_NAME_OCTETS);
    }

    static int firstInvalidCookieValueOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_VALUE_OCTETS);
    }

    static int firstInvalidOctet(CharSequence cs, BitSet bits2) {
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            if (bits2.get(c)) continue;
            return i;
        }
        return -1;
    }

    static CharSequence unwrapValue(CharSequence cs) {
        int len2 = cs.length();
        if (len2 > 0 && cs.charAt(0) == '\"') {
            if (len2 >= 2 && cs.charAt(len2 - 1) == '\"') {
                return len2 == 2 ? "" : cs.subSequence(1, len2 - 1);
            }
            return null;
        }
        return cs;
    }

    static String validateAttributeValue(String name, String value2) {
        if (value2 == null) {
            return null;
        }
        if ((value2 = value2.trim()).isEmpty()) {
            return null;
        }
        int i = CookieUtil.firstInvalidOctet(value2, VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS);
        if (i != -1) {
            throw new IllegalArgumentException(name + " contains the prohibited characters: " + value2.charAt(i));
        }
        return value2;
    }

    private CookieUtil() {
    }
}

