/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http.cookie;

import java.nio.CharBuffer;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.CookieUtil;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.DefaultCookie;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLogger;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class CookieDecoder {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private final boolean strict;

    protected CookieDecoder(boolean strict) {
        this.strict = strict;
    }

    protected DefaultCookie initCookie(String header2, int nameBegin, int nameEnd, int valueBegin, int valueEnd) {
        boolean wrap2;
        int invalidOctetPos;
        if (nameBegin == -1 || nameBegin == nameEnd) {
            this.logger.debug("Skipping cookie with null name");
            return null;
        }
        if (valueBegin == -1) {
            this.logger.debug("Skipping cookie with null value");
            return null;
        }
        CharBuffer wrappedValue = CharBuffer.wrap(header2, valueBegin, valueEnd);
        CharSequence unwrappedValue = CookieUtil.unwrapValue(wrappedValue);
        if (unwrappedValue == null) {
            this.logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)wrappedValue);
            return null;
        }
        String name = header2.substring(nameBegin, nameEnd);
        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieNameOctet(name)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)name, (Object)Character.valueOf(name.charAt(invalidOctetPos)));
            }
            return null;
        }
        boolean bl = wrap2 = unwrappedValue.length() != valueEnd - valueBegin;
        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)unwrappedValue, (Object)Character.valueOf(unwrappedValue.charAt(invalidOctetPos)));
            }
            return null;
        }
        DefaultCookie cookie2 = new DefaultCookie(name, unwrappedValue.toString());
        cookie2.setWrap(wrap2);
        return cookie2;
    }
}

