/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http.cookie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.CookieEncoder;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.CookieUtil;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.DefaultCookie;
import play.shaded.ahc.io.netty.util.internal.InternalThreadLocalMap;
import play.shaded.ahc.io.netty.util.internal.ObjectUtil;

public final class ClientCookieEncoder
extends CookieEncoder {
    public static final ClientCookieEncoder STRICT = new ClientCookieEncoder(true);
    public static final ClientCookieEncoder LAX = new ClientCookieEncoder(false);
    private static final Comparator<Cookie> COOKIE_COMPARATOR = new Comparator<Cookie>(){

        @Override
        public int compare(Cookie c1, Cookie c2) {
            int len1;
            String path1 = c1.path();
            String path2 = c2.path();
            int len2 = path2 == null ? Integer.MAX_VALUE : path2.length();
            int diff2 = len2 - (len1 = path1 == null ? Integer.MAX_VALUE : path1.length());
            if (diff2 != 0) {
                return diff2;
            }
            return -1;
        }
    };

    private ClientCookieEncoder(boolean strict) {
        super(strict);
    }

    public String encode(String name, String value2) {
        return this.encode((Cookie)new DefaultCookie(name, value2));
    }

    public String encode(Cookie cookie2) {
        StringBuilder buf = CookieUtil.stringBuilder();
        this.encode(buf, ObjectUtil.checkNotNull(cookie2, "cookie"));
        return CookieUtil.stripTrailingSeparator(buf);
    }

    public String encode(Cookie ... cookies2) {
        if (ObjectUtil.checkNotNull(cookies2, "cookies").length == 0) {
            return null;
        }
        StringBuilder buf = CookieUtil.stringBuilder();
        if (this.strict) {
            if (cookies2.length == 1) {
                this.encode(buf, cookies2[0]);
            } else {
                Cookie[] cookiesSorted = Arrays.copyOf(cookies2, cookies2.length);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    this.encode(buf, c);
                }
            }
        } else {
            for (Cookie c : cookies2) {
                this.encode(buf, c);
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull(buf);
    }

    public String encode(Collection<? extends Cookie> cookies2) {
        if (ObjectUtil.checkNotNull(cookies2, "cookies").isEmpty()) {
            return null;
        }
        StringBuilder buf = CookieUtil.stringBuilder();
        if (this.strict) {
            if (cookies2.size() == 1) {
                this.encode(buf, cookies2.iterator().next());
            } else {
                Cookie[] cookiesSorted = cookies2.toArray(new Cookie[0]);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    this.encode(buf, c);
                }
            }
        } else {
            for (Cookie cookie2 : cookies2) {
                this.encode(buf, cookie2);
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull(buf);
    }

    public String encode(Iterable<? extends Cookie> cookies2) {
        Iterator<? extends Cookie> cookiesIt = ObjectUtil.checkNotNull(cookies2, "cookies").iterator();
        if (!cookiesIt.hasNext()) {
            return null;
        }
        StringBuilder buf = CookieUtil.stringBuilder();
        if (this.strict) {
            Cookie firstCookie = cookiesIt.next();
            if (!cookiesIt.hasNext()) {
                this.encode(buf, firstCookie);
            } else {
                ArrayList<Cookie> cookiesList = InternalThreadLocalMap.get().arrayList();
                cookiesList.add(firstCookie);
                while (cookiesIt.hasNext()) {
                    cookiesList.add(cookiesIt.next());
                }
                Cookie[] cookiesSorted = cookiesList.toArray(new Cookie[0]);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    this.encode(buf, c);
                }
            }
        } else {
            while (cookiesIt.hasNext()) {
                this.encode(buf, cookiesIt.next());
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull(buf);
    }

    private void encode(StringBuilder buf, Cookie c) {
        String name = c.name();
        String value2 = c.value() != null ? c.value() : "";
        this.validateCookie(name, value2);
        if (c.wrap()) {
            CookieUtil.addQuoted(buf, name, value2);
        } else {
            CookieUtil.add(buf, name, value2);
        }
    }
}

