/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http;

import play.shaded.ahc.io.netty.util.AsciiString;

public enum HttpStatusClass {
    INFORMATIONAL(100, 200, "Informational"),
    SUCCESS(200, 300, "Success"),
    REDIRECTION(300, 400, "Redirection"),
    CLIENT_ERROR(400, 500, "Client Error"),
    SERVER_ERROR(500, 600, "Server Error"),
    UNKNOWN(0, 0, "Unknown Status"){

        @Override
        public boolean contains(int code2) {
            return code2 < 100 || code2 >= 600;
        }
    };

    private final int min;
    private final int max;
    private final AsciiString defaultReasonPhrase;

    public static HttpStatusClass valueOf(int code2) {
        if (INFORMATIONAL.contains(code2)) {
            return INFORMATIONAL;
        }
        if (SUCCESS.contains(code2)) {
            return SUCCESS;
        }
        if (REDIRECTION.contains(code2)) {
            return REDIRECTION;
        }
        if (CLIENT_ERROR.contains(code2)) {
            return CLIENT_ERROR;
        }
        if (SERVER_ERROR.contains(code2)) {
            return SERVER_ERROR;
        }
        return UNKNOWN;
    }

    public static HttpStatusClass valueOf(CharSequence code2) {
        if (code2 != null && code2.length() == 3) {
            char c0 = code2.charAt(0);
            return HttpStatusClass.isDigit(c0) && HttpStatusClass.isDigit(code2.charAt(1)) && HttpStatusClass.isDigit(code2.charAt(2)) ? HttpStatusClass.valueOf(HttpStatusClass.digit(c0) * 100) : UNKNOWN;
        }
        return UNKNOWN;
    }

    private static int digit(char c) {
        return c - 48;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private HttpStatusClass(int min2, int max2, String defaultReasonPhrase) {
        this.min = min2;
        this.max = max2;
        this.defaultReasonPhrase = AsciiString.cached(defaultReasonPhrase);
    }

    public boolean contains(int code2) {
        return code2 >= this.min && code2 < this.max;
    }

    AsciiString defaultReasonPhrase() {
        return this.defaultReasonPhrase;
    }
}

