/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http;

import play.shaded.ahc.io.netty.buffer.Unpooled;
import play.shaded.ahc.io.netty.channel.ChannelFutureListener;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.channel.ChannelInboundHandlerAdapter;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultFullHttpResponse;
import play.shaded.ahc.io.netty.handler.codec.http.FullHttpResponse;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.HttpRequest;
import play.shaded.ahc.io.netty.handler.codec.http.HttpResponse;
import play.shaded.ahc.io.netty.handler.codec.http.HttpResponseStatus;
import play.shaded.ahc.io.netty.handler.codec.http.HttpUtil;
import play.shaded.ahc.io.netty.handler.codec.http.HttpVersion;
import play.shaded.ahc.io.netty.util.ReferenceCountUtil;

public class HttpServerExpectContinueHandler
extends ChannelInboundHandlerAdapter {
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse ACCEPT = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);

    protected HttpResponse acceptMessage(HttpRequest request2) {
        return ACCEPT.retainedDuplicate();
    }

    protected HttpResponse rejectResponse(HttpRequest request2) {
        return EXPECTATION_FAILED.retainedDuplicate();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpRequest req;
        if (msg instanceof HttpRequest && HttpUtil.is100ContinueExpected(req = (HttpRequest)msg)) {
            HttpResponse accept2 = this.acceptMessage(req);
            if (accept2 == null) {
                HttpResponse rejection = this.rejectResponse(req);
                ReferenceCountUtil.release(msg);
                ctx.writeAndFlush(rejection).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
                return;
            }
            ctx.writeAndFlush(accept2).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
            req.headers().remove(HttpHeaderNames.EXPECT);
        }
        super.channelRead(ctx, msg);
    }

    static {
        EXPECTATION_FAILED.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        ACCEPT.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
    }
}

